/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.QueryBase;
import io.vertx.sqlclient.impl.QueryExecutor;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlClientInternal;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.CompositeCommand;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class SqlClientBase<C extends SqlClient>
implements SqlClientInternal,
CommandScheduler {
    protected final QueryTracer tracer;
    protected final ClientMetrics metrics;

    public SqlClientBase(QueryTracer tracer, ClientMetrics metrics) {
        this.tracer = tracer;
        this.metrics = metrics;
    }

    @Override
    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append("?");
        return current;
    }

    protected abstract ContextInternal context();

    protected abstract <T> PromiseInternal<T> promise();

    protected abstract <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> var1);

    @Override
    public Query<RowSet<Row>> query(String sql) {
        QueryExecutor builder = new QueryExecutor(this.tracer, this.metrics, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new QueryImpl(this.autoCommit(), false, sql, builder);
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.preparedQuery(sql, null);
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        QueryExecutor builder = new QueryExecutor(this.tracer, this.metrics, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new PreparedQueryImpl(this.autoCommit(), false, sql, options, builder);
    }

    boolean autoCommit() {
        return true;
    }

    @Override
    public void group(Handler<SqlClient> block) {
        GroupingClient grouping = new GroupingClient(this.tracer, this.metrics);
        block.handle((Object)grouping);
        this.schedule(this.context(), grouping.composite);
    }

    private class GroupingClient
    extends SqlClientBase<GroupingClient> {
        private CompositeCommand composite;

        public GroupingClient(QueryTracer tracer, ClientMetrics metrics) {
            super(tracer, metrics);
            this.composite = new CompositeCommand();
        }

        @Override
        public void close(Handler<AsyncResult<Void>> handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<Void> close() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected ContextInternal context() {
            return SqlClientBase.this.context();
        }

        @Override
        protected <T> PromiseInternal<T> promise() {
            return SqlClientBase.this.promise();
        }

        @Override
        protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
            return SqlClientBase.this.promise(handler);
        }

        @Override
        public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
            return this.composite.add(context, cmd);
        }
    }

    private class PreparedQueryImpl<T, R extends SqlResult<T>>
    extends QueryImpl<T, R>
    implements PreparedQuery<R> {
        private final PrepareOptions options;

        private PreparedQueryImpl(boolean autoCommit, boolean singleton, String sql, PrepareOptions options, QueryExecutor<T, ?, R> builder) {
            super(autoCommit, singleton, sql, builder);
            this.options = options;
        }

        @Override
        public <U> PreparedQuery<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
            return (PreparedQuery)super.collecting(collector);
        }

        @Override
        public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
            return (PreparedQuery)super.mapping(mapper);
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(QueryExecutor<T2, ?, R2> builder) {
            return new PreparedQueryImpl<T2, R2>(this.autoCommit, this.singleton, this.sql, this.options, builder);
        }

        @Override
        protected void execute(PromiseInternal<R> promise) {
            this.execute(ArrayTuple.EMPTY, promise);
        }

        private void execute(Tuple arguments, PromiseInternal<R> promise) {
            this.builder.executeExtendedQuery(SqlClientBase.this, this.sql, this.options, this.autoCommit, arguments, promise);
        }

        @Override
        public void execute(Tuple tuple, Handler<AsyncResult<R>> handler) {
            this.execute(tuple, SqlClientBase.this.promise(handler));
        }

        @Override
        public Future<R> execute(Tuple tuple) {
            PromiseInternal promise = SqlClientBase.this.promise();
            this.execute(tuple, (Handler<AsyncResult<R>>)promise);
            return promise.future();
        }

        @Override
        public void executeBatch(List<Tuple> batch, Handler<AsyncResult<R>> handler) {
            this.executeBatch(batch, SqlClientBase.this.promise(handler));
        }

        @Override
        public Future<R> executeBatch(List<Tuple> batch) {
            PromiseInternal promise = SqlClientBase.this.promise();
            this.executeBatch(batch, (Handler<AsyncResult<R>>)promise);
            return promise.future();
        }

        private void executeBatch(List<Tuple> batch, PromiseInternal<R> promise) {
            this.builder.executeBatchQuery((CommandScheduler)SqlClientBase.this, this.sql, this.options, this.autoCommit, batch, promise);
        }
    }

    private class QueryImpl<T, R extends SqlResult<T>>
    extends QueryBase<T, R> {
        protected final boolean autoCommit;
        protected final boolean singleton;
        protected final String sql;

        private QueryImpl(boolean autoCommit, boolean singleton, String sql, QueryExecutor<T, ?, R> builder) {
            super(builder);
            this.autoCommit = autoCommit;
            this.singleton = singleton;
            this.sql = sql;
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(QueryExecutor<T2, ?, R2> builder) {
            return new QueryImpl<T2, R2>(this.autoCommit, this.singleton, this.sql, builder);
        }

        @Override
        public void execute(Handler<AsyncResult<R>> handler) {
            this.execute(SqlClientBase.this.promise(handler));
        }

        @Override
        public Future<R> execute() {
            PromiseInternal promise = SqlClientBase.this.promise();
            this.execute((Handler<AsyncResult<R>>)promise);
            return promise.future();
        }

        protected void execute(PromiseInternal<R> promise) {
            this.builder.executeSimpleQuery(SqlClientBase.this, this.sql, this.autoCommit, this.singleton, promise);
        }
    }
}

