/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;

public abstract class SqlConnectionBase<C extends SqlClient>
extends SqlClientBase<C> {
    protected final ContextInternal context;
    protected final ConnectionFactory factory;
    protected final Connection conn;

    protected SqlConnectionBase(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(tracer, metrics);
        this.context = context;
        this.factory = factory;
        this.conn = conn;
    }

    public ConnectionFactory factory() {
        return this.factory;
    }

    public Connection unwrap() {
        return this.conn;
    }

    public C prepare(String sql, PrepareOptions options, Handler<AsyncResult<PreparedStatement>> handler) {
        Future<PreparedStatement> fut = this.prepare(sql, options);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (C)this;
    }

    public Future<PreparedStatement> prepare(String sql, PrepareOptions options) {
        return this.schedule(this.context, new PrepareStatementCommand(sql, options, true)).compose(cr -> Future.succeededFuture((Object)PreparedStatementImpl.create(this.conn, this.tracer, this.metrics, this.context, cr, this.autoCommit())), err -> {
            if (this.conn.isIndeterminatePreparedStatementError((Throwable)err)) {
                return Future.succeededFuture((Object)PreparedStatementImpl.create(this.conn, this.tracer, this.metrics, this.context, options, sql, this.autoCommit()));
            }
            return Future.failedFuture((Throwable)err);
        });
    }

    public C prepare(String sql, Handler<AsyncResult<PreparedStatement>> handler) {
        return this.prepare(sql, null, handler);
    }

    public Future<PreparedStatement> prepare(String sql) {
        return this.prepare(sql, (PrepareOptions)null);
    }
}

