/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Tuple;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class Utils {
    private Utils() {
    }

    public static Object toJson(Object value) {
        if (value == null || value == Tuple.JSON_NULL) {
            return null;
        }
        if (value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Buffer || value instanceof JsonObject || value instanceof JsonArray) {
            return value;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            JsonArray array = new JsonArray(new ArrayList(len));
            for (int idx = 0; idx < len; ++idx) {
                Object component = Utils.toJson(Array.get(value, idx));
                array.add(component);
            }
            return array;
        }
        return value.toString();
    }

    public static <T> Supplier<Future<T>> roundRobinSupplier(final List<T> factories) {
        return new Supplier<Future<T>>(){
            final AtomicLong idx = new AtomicLong();

            @Override
            public Future<T> get() {
                long val = this.idx.getAndIncrement();
                Object f = factories.get((int)val % factories.size());
                return Future.succeededFuture(f);
            }
        };
    }
}

