/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ClientBuilderBase;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;
import java.util.function.Supplier;

@VertxGen
public interface ClientBuilder<C> {
    @GenIgnore
    public static ClientBuilder<Pool> pool(Driver driver) {
        return new ClientBuilderBase<Pool>(driver){

            @Override
            protected Pool create(Vertx vertx, Supplier<Future<SqlConnectOptions>> databases, PoolOptions poolOptions) {
                return this.driver.createPool(vertx, databases, poolOptions);
            }
        };
    }

    @GenIgnore
    public static Pool pool(Driver driver, Handler<ClientBuilder<Pool>> block) {
        ClientBuilder<Pool> builder = ClientBuilder.pool(driver);
        block.handle(builder);
        return builder.build();
    }

    @Fluent
    public ClientBuilder<C> with(PoolOptions var1);

    @Fluent
    public ClientBuilder<C> connectingTo(SqlConnectOptions var1);

    @Fluent
    public ClientBuilder<C> connectingTo(String var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public ClientBuilder<C> connectingTo(Supplier<Future<SqlConnectOptions>> var1);

    @Fluent
    public ClientBuilder<C> connectingTo(List<SqlConnectOptions> var1);

    @Fluent
    public ClientBuilder<C> using(Vertx var1);

    @Fluent
    public ClientBuilder<C> withConnectHandler(Handler<SqlConnection> var1);

    public C build();
}

