/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PoolOptionsConverter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class PoolOptions {
    public static final int DEFAULT_MAX_SIZE = 4;
    public static final int DEFAULT_MAX_WAIT_QUEUE_SIZE = -1;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    public static final int DEFAULT_MAXIMUM_LIFETIME = 0;
    public static final TimeUnit DEFAULT_IDLE_TIMEOUT_TIME_UNIT = TimeUnit.SECONDS;
    public static final TimeUnit DEFAULT_MAXIMUM_LIFETIME_TIME_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_POOL_CLEANER_PERIOD = 1000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30;
    public static final TimeUnit DEFAULT_CONNECTION_TIMEOUT_TIME_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_SHARED_POOL = false;
    public static final String DEFAULT_NAME = "__vertx.DEFAULT";
    public static final int DEFAULT_EVENT_LOOP_SIZE = 0;
    private int maxSize = 4;
    private int maxWaitQueueSize = -1;
    private int idleTimeout = 0;
    private TimeUnit idleTimeoutUnit = DEFAULT_IDLE_TIMEOUT_TIME_UNIT;
    private int maxLifetime = 0;
    private TimeUnit maxLifetimeUnit = DEFAULT_MAXIMUM_LIFETIME_TIME_UNIT;
    private int poolCleanerPeriod = 1000;
    private int connectionTimeout = 30;
    private TimeUnit connectionTimeoutUnit = DEFAULT_CONNECTION_TIMEOUT_TIME_UNIT;
    private boolean shared = false;
    private String name = "__vertx.DEFAULT";
    private int eventLoopSize = 0;

    public PoolOptions() {
    }

    public PoolOptions(JsonObject json) {
        PoolOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public PoolOptions(PoolOptions other) {
        this.maxSize = other.maxSize;
        this.maxWaitQueueSize = other.maxWaitQueueSize;
        this.idleTimeout = other.idleTimeout;
        this.idleTimeoutUnit = other.idleTimeoutUnit;
        this.shared = other.shared;
        this.name = other.name;
        this.eventLoopSize = other.eventLoopSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PoolOptions setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max size cannot be negative");
        }
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public PoolOptions setMaxWaitQueueSize(int maxWaitQueueSize) {
        this.maxWaitQueueSize = maxWaitQueueSize;
        return this;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.idleTimeoutUnit;
    }

    public PoolOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        this.idleTimeoutUnit = idleTimeoutUnit;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public PoolOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
        return this;
    }

    public TimeUnit getMaxLifetimeUnit() {
        return this.maxLifetimeUnit;
    }

    public PoolOptions setMaxLifetimeUnit(TimeUnit maxLifetimeUnit) {
        this.maxLifetimeUnit = maxLifetimeUnit;
        return this;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public PoolOptions setMaxLifetime(int maxLifetime) {
        if (maxLifetime < 0) {
            throw new IllegalArgumentException("maxLifetime must be >= 0");
        }
        this.maxLifetime = maxLifetime;
        return this;
    }

    public int getPoolCleanerPeriod() {
        return this.poolCleanerPeriod;
    }

    public PoolOptions setPoolCleanerPeriod(int poolCleanerPeriod) {
        this.poolCleanerPeriod = poolCleanerPeriod;
        return this;
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.connectionTimeoutUnit;
    }

    public PoolOptions setConnectionTimeoutUnit(TimeUnit timeoutUnit) {
        this.connectionTimeoutUnit = timeoutUnit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public PoolOptions setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        return this;
    }

    public boolean isShared() {
        return this.shared;
    }

    public PoolOptions setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PoolOptions setName(String name) {
        Objects.requireNonNull(name, "Pool name cannot be null");
        this.name = name;
        return this;
    }

    public int getEventLoopSize() {
        return this.eventLoopSize;
    }

    public PoolOptions setEventLoopSize(int eventLoopSize) {
        if (eventLoopSize < 0) {
            throw new IllegalArgumentException("poolEventLoopSize must be >= 0");
        }
        this.eventLoopSize = eventLoopSize;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PoolOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PoolOptions that = (PoolOptions)o;
        return this.maxSize == that.maxSize;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxSize;
        return result;
    }
}

