/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.CloseSequence;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;

public abstract class ConnectionFactoryBase<C extends SqlConnectOptions>
implements ConnectionFactory<C> {
    public static final String NATIVE_TRANSPORT_REQUIRED = "The Vertx instance must use a native transport in order to connect to connect through domain sockets";
    protected final VertxInternal vertx;
    protected final NetClient client;
    protected final NetClientOptions tcpOptions;
    protected final CloseSequence clientCloseFuture = new CloseSequence(new Closeable[]{this::doClose});

    protected ConnectionFactoryBase(VertxInternal vertx) {
        this(vertx, new NetClientOptions());
    }

    protected ConnectionFactoryBase(VertxInternal vertx, NetClientOptions tcpOptions) {
        this.vertx = vertx;
        this.client = vertx.createNetClient(new NetClientOptions(tcpOptions).setReconnectAttempts(0));
        this.tcpOptions = tcpOptions;
    }

    private void doClose(Promise<Void> p) {
        this.client.close().onComplete(ar -> p.complete());
    }

    public static ContextInternal asEventLoopContext(ContextInternal ctx) {
        return ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.owner().getWorkerPool(), ctx.classLoader());
    }

    public Future<Connection> connect(ContextInternal context, C options) {
        PromiseInternal promise = context.promise();
        context.emit((Object)promise, p -> this.doConnectWithRetry(options, (PromiseInternal<Connection>)p, options.getReconnectAttempts()));
        return promise.future();
    }

    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    private void doConnectWithRetry(C options, PromiseInternal<Connection> promise, int remainingAttempts) {
        ContextInternal ctx = promise.context();
        this.doConnectInternal(options, ctx).onComplete(ar -> {
            if (ar.succeeded()) {
                promise.complete((Object)((Connection)ar.result()));
            } else if (remainingAttempts > 0) {
                ctx.owner().setTimer(options.getReconnectInterval(), id -> this.doConnectWithRetry(options, promise, remainingAttempts - 1));
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    protected abstract Future<Connection> doConnectInternal(C var1, ContextInternal var2);
}

