/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.pool;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.pool.PoolWaiter;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.tracing.QueryReporter;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionBase;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.QueryCommandBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SqlConnectionPool {
    private static final Object NO_METRICS = new Object();
    private final Function<Context, Future<SqlConnection>> connectionProvider;
    private final VertxInternal vertx;
    private final PoolMetrics metrics;
    private final ConnectionPool<PooledConnection> pool;
    private final Handler<PooledConnection> hook;
    private final Function<Connection, Future<Void>> afterAcquire;
    private final Function<Connection, Future<Void>> beforeRecycle;
    private final boolean pipelined;
    private final long idleTimeout;
    private final long maxLifetime;
    private final int maxSize;
    private final PoolConnector<PooledConnection> connector = new PoolConnector<PooledConnection>(){

        public Future<ConnectResult<PooledConnection>> connect(ContextInternal context, PoolConnector.Listener listener) {
            Future<SqlConnection> future = SqlConnectionPool.this.connectionProvider.apply((Context)context);
            return future.compose(res -> {
                SqlConnectionBase connBase = (SqlConnectionBase)res;
                Connection conn = connBase.unwrap();
                if (conn.isValid()) {
                    PooledConnection pooled = new PooledConnection(connBase.factory(), conn, listener);
                    conn.init(pooled);
                    if (SqlConnectionPool.this.hook != null) {
                        Promise p;
                        pooled.poolCallback = p = Promise.promise();
                        SqlConnectionPool.this.hook.handle((Object)pooled);
                        return p.future();
                    }
                    return Future.succeededFuture((Object)new ConnectResult((Object)pooled, SqlConnectionPool.this.pipelined ? (long)conn.pipeliningLimit() : 1L, 0L));
                }
                return Future.failedFuture((Throwable)NetSocketInternal.CLOSED_EXCEPTION);
            });
        }

        public boolean isValid(PooledConnection connection) {
            return true;
        }
    };

    public SqlConnectionPool(Function<Context, Future<SqlConnection>> connectionProvider, PoolMetrics metrics, Handler<PooledConnection> hook, Function<Connection, Future<Void>> afterAcquire, Function<Connection, Future<Void>> beforeRecycle, final VertxInternal vertx, long idleTimeout, long maxLifetime, int maxSize, boolean pipelined, int maxWaitQueueSize, int eventLoopSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        if (afterAcquire != null && beforeRecycle == null) {
            throw new IllegalArgumentException("afterAcquire and beforeRecycle hooks must be both not null");
        }
        this.pool = ConnectionPool.pool(this.connector, (int[])new int[]{maxSize}, (int)maxWaitQueueSize);
        this.metrics = metrics;
        this.vertx = vertx;
        this.pipelined = pipelined;
        this.idleTimeout = idleTimeout;
        this.maxLifetime = maxLifetime;
        this.maxSize = maxSize;
        this.hook = hook;
        this.connectionProvider = connectionProvider;
        this.afterAcquire = afterAcquire;
        this.beforeRecycle = beforeRecycle;
        if (eventLoopSize > 0) {
            final EventLoop[] loops = new EventLoop[eventLoopSize];
            for (int i = 0; i < eventLoopSize; ++i) {
                loops[i] = vertx.nettyEventLoopGroup().next();
            }
            this.pool.contextProvider((Function)new Function<ContextInternal, ContextInternal>(){
                int idx = 0;

                @Override
                public ContextInternal apply(ContextInternal contextInternal) {
                    EventLoop loop = loops[this.idx++];
                    if (this.idx == loops.length) {
                        this.idx = 0;
                    }
                    return vertx.contextBuilder().withEventLoop(loop).build();
                }
            });
        } else {
            this.pool.contextProvider(ctx -> ctx.owner().contextBuilder().withEventLoop(ctx.nettyEventLoop()).build());
        }
    }

    public int available() {
        return this.maxSize - this.pool.size();
    }

    public int size() {
        return this.pool.size();
    }

    public void evict() {
        long now = System.currentTimeMillis();
        this.pool.evict(conn -> conn.shouldEvict(now)).onComplete(ar -> {
            if (ar.succeeded()) {
                List res = (List)ar.result();
                for (PooledConnection conn : res) {
                    conn.close((Promise<Void>)Promise.promise());
                }
            }
        });
    }

    private Object enqueueMetric() {
        if (this.metrics != null) {
            try {
                return this.metrics.enqueue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NO_METRICS;
    }

    private void dequeueMetric(Object metric) {
        if (this.metrics != null && metric != NO_METRICS) {
            try {
                this.metrics.dequeue(metric);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public <R> Future<R> execute(ContextInternal context, CommandBase<R> cmd) {
        PromiseInternal p = context.promise();
        Object metric = this.enqueueMetric();
        this.pool.acquire(context, 0).onComplete((Completable)p);
        return p.future().compose(lease -> {
            this.dequeueMetric(metric);
            PooledConnection pooled = (PooledConnection)lease.get();
            Connection conn = pooled.conn;
            Future future = this.afterAcquire != null ? this.afterAcquire.apply(conn).compose(v -> pooled.schedule(context, cmd)).eventually(() -> this.beforeRecycle.apply(conn)) : pooled.schedule(context, cmd);
            return future.andThen(ar -> {
                pooled.refresh();
                lease.recycle();
            });
        });
    }

    public void acquire(final ContextInternal context, final long timeout, final Completable<PooledConnection> handler) {
        Object metric = this.enqueueMetric();
        class PoolRequest
        implements PoolWaiter.Listener<PooledConnection>,
        Completable<Lease<PooledConnection>> {
            private final Object metric;
            private long timerID = -1L;

            PoolRequest(Object metric) {
                this.metric = metric;
            }

            public void complete(Lease<PooledConnection> lease, Throwable failure) {
                if (this.timerID != -1L) {
                    SqlConnectionPool.this.vertx.cancelTimer(this.timerID);
                }
                if (failure == null) {
                    if (SqlConnectionPool.this.afterAcquire != null) {
                        SqlConnectionPool.this.afterAcquire.apply(((PooledConnection)lease.get()).conn).onComplete(ar2 -> {
                            if (ar2.succeeded()) {
                                this.handle(lease);
                            } else {
                                handler.fail(failure);
                            }
                        });
                    } else {
                        this.handle(lease);
                    }
                } else {
                    handler.fail(failure);
                }
            }

            private void handle(Lease<PooledConnection> lease) {
                SqlConnectionPool.this.dequeueMetric(this.metric);
                PooledConnection pooled = (PooledConnection)lease.get();
                pooled.lease = lease;
                handler.succeed((Object)pooled);
            }

            public void onEnqueue(PoolWaiter<PooledConnection> waiter) {
                if (timeout > 0L && this.timerID == -1L) {
                    this.timerID = context.setTimer(timeout, id -> SqlConnectionPool.this.pool.cancel(waiter).onComplete(ar -> {
                        if (ar.succeeded() && ((Boolean)ar.result()).booleanValue()) {
                            handler.fail("Timeout");
                        }
                    }));
                }
            }

            public void onConnect(PoolWaiter<PooledConnection> waiter) {
                this.onEnqueue(waiter);
            }
        }
        PoolRequest request = new PoolRequest(metric);
        this.pool.acquire(context, (PoolWaiter.Listener)request, 0).onComplete((Completable)request);
    }

    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.pool.close().onComplete(arg_0 -> SqlConnectionPool.lambda$close$10((Promise)promise, arg_0));
        return promise.future();
    }

    private static /* synthetic */ void lambda$close$10(Promise promise, AsyncResult ar1) {
        if (ar1.succeeded()) {
            List results = ((List)ar1.result()).stream().map(connection -> connection.compose(pooled -> Future.future(p -> pooled.conn.close((Connection.Holder)pooled, (Promise<Void>)p)))).collect(Collectors.toList());
            Future.join(results).mapEmpty().onComplete((Completable)promise);
        } else {
            promise.fail(ar1.cause());
        }
    }

    public class PooledConnection
    implements Connection,
    Connection.Holder {
        private final ConnectionFactory factory;
        private final Connection conn;
        private final PoolConnector.Listener listener;
        private Connection.Holder holder;
        private Promise<ConnectResult<PooledConnection>> poolCallback;
        private Lease<PooledConnection> lease;
        public long idleEvictionTimestamp;
        public long lifetimeEvictionTimestamp;

        PooledConnection(ConnectionFactory factory, Connection conn, PoolConnector.Listener listener) {
            this.factory = factory;
            this.conn = conn;
            this.listener = listener;
            this.lifetimeEvictionTimestamp = SqlConnectionPool.this.maxLifetime > 0L ? System.currentTimeMillis() + SqlConnectionPool.this.maxLifetime : Long.MAX_VALUE;
            this.refresh();
        }

        @Override
        public ClientMetrics metrics() {
            return this.conn.metrics();
        }

        @Override
        public TracingPolicy tracingPolicy() {
            return this.conn.tracingPolicy();
        }

        @Override
        public String system() {
            return this.conn.system();
        }

        @Override
        public String database() {
            return this.conn.database();
        }

        @Override
        public String user() {
            return this.conn.user();
        }

        public ConnectionFactory factory() {
            return this.factory;
        }

        @Override
        public SocketAddress server() {
            return this.conn.server();
        }

        @Override
        public boolean isSsl() {
            return this.conn.isSsl();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public int pipeliningLimit() {
            return this.conn.pipeliningLimit();
        }

        @Override
        public DatabaseMetadata getDatabaseMetaData() {
            return this.conn.getDatabaseMetaData();
        }

        @Override
        public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
            QueryReporter queryReporter;
            VertxTracer tracer = SqlConnectionPool.this.vertx.tracer();
            ClientMetrics metrics = this.conn.metrics();
            if (cmd instanceof QueryCommandBase && (tracer != null || metrics != null)) {
                queryReporter = new QueryReporter(tracer, metrics, context, (QueryCommandBase)cmd, this.conn);
                queryReporter.before();
            } else {
                queryReporter = null;
            }
            Future fut = this.conn.schedule(context, cmd);
            if (queryReporter != null) {
                fut = fut.andThen(queryReporter::after);
            }
            return fut;
        }

        private void close(Promise<Void> promise) {
            this.conn.close(this, promise);
        }

        private void refresh() {
            this.idleEvictionTimestamp = SqlConnectionPool.this.idleTimeout > 0L ? System.currentTimeMillis() + SqlConnectionPool.this.idleTimeout : Long.MAX_VALUE;
        }

        @Override
        public void init(Connection.Holder holder) {
            if (this.holder != null) {
                throw new IllegalStateException();
            }
            this.holder = holder;
        }

        @Override
        public void close(Connection.Holder holder, Promise<Void> promise) {
            this.doClose(holder, promise);
        }

        private void doClose(Connection.Holder holder, Promise<Void> promise) {
            if (holder != this.holder) {
                Object msg = this.holder == null ? "Connection released twice" : "Connection released by " + holder + " owned by " + this.holder;
                promise.fail((String)msg);
            } else {
                this.holder = null;
                Promise<ConnectResult<PooledConnection>> resultHandler = this.poolCallback;
                if (resultHandler != null) {
                    this.poolCallback = null;
                    promise.complete();
                    resultHandler.complete((Object)new ConnectResult((Object)this, SqlConnectionPool.this.pipelined ? (long)this.conn.pipeliningLimit() : 1L, 0L));
                    return;
                }
                if (SqlConnectionPool.this.beforeRecycle == null) {
                    this.cleanup(promise);
                } else {
                    SqlConnectionPool.this.beforeRecycle.apply(((PooledConnection)this.lease.get()).conn).onComplete(ar -> this.cleanup(promise));
                }
            }
        }

        private void cleanup(Promise<Void> promise) {
            Lease<PooledConnection> l = this.lease;
            this.lease = null;
            this.refresh();
            l.recycle();
            promise.complete();
        }

        @Override
        public void handleClosed() {
            Promise<ConnectResult<PooledConnection>> resultHandler;
            if (this.holder != null) {
                this.holder.handleClosed();
            }
            if ((resultHandler = this.poolCallback) != null) {
                this.poolCallback = null;
                resultHandler.fail((Throwable)NetSocketInternal.CLOSED_EXCEPTION);
            }
            this.listener.onRemove();
        }

        @Override
        public void handleEvent(Object event) {
            if (this.holder != null) {
                this.holder.handleEvent(event);
            }
        }

        @Override
        public void handleException(Throwable err) {
            if (this.holder != null) {
                this.holder.handleException(err);
            }
        }

        @Override
        public int getProcessId() {
            return this.conn.getProcessId();
        }

        @Override
        public int getSecretKey() {
            return this.conn.getSecretKey();
        }

        @Override
        public Connection unwrap() {
            return this.conn;
        }

        private boolean hasIdleExpired(long now) {
            return this.idleEvictionTimestamp < now;
        }

        private boolean hasLifetimeExpired(long now) {
            return this.lifetimeEvictionTimestamp < now;
        }

        private boolean shouldEvict(long now) {
            return this.hasIdleExpired(now) || this.hasLifetimeExpired(now);
        }
    }
}

