/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.internal.pool;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.pool.SqlConnectionPool;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlClientBase;
import io.vertx.sqlclient.internal.SqlConnectionInternal;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.spi.Driver;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class PoolImpl
extends SqlClientBase
implements Pool,
Closeable {
    private final VertxInternal vertx;
    private final SqlConnectionPool pool;
    private final CloseFuture closeFuture;
    private final long idleTimeout;
    private final long connectionTimeout;
    private final long maxLifetime;
    private final long cleanerPeriod;
    private final boolean pipelined;
    private final Handler<SqlConnection> connectionInitializer;
    private long timerID;
    public static final String PROPAGATABLE_CONNECTION = "propagatable_connection";

    public PoolImpl(VertxInternal vertx, Driver driver, boolean pipelined, PoolOptions poolOptions, Function<Connection, Future<Void>> afterAcquire, Function<Connection, Future<Void>> beforeRecycle, Function<Context, Future<SqlConnection>> connectionProvider, Handler<SqlConnection> connectionInitializer, CloseFuture closeFuture) {
        super(driver);
        Handler hook = connectionInitializer != null ? this::initializeConnection : null;
        VertxMetrics metrics = vertx.metrics();
        PoolMetrics poolMetrics = metrics != null ? metrics.createPoolMetrics("sql", poolOptions.getName(), poolOptions.getMaxSize()) : null;
        this.idleTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getIdleTimeout(), poolOptions.getIdleTimeoutUnit());
        this.connectionTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getConnectionTimeout(), poolOptions.getConnectionTimeoutUnit());
        this.maxLifetime = TimeUnit.MILLISECONDS.convert(poolOptions.getMaxLifetime(), poolOptions.getMaxLifetimeUnit());
        this.cleanerPeriod = poolOptions.getPoolCleanerPeriod();
        this.timerID = -1L;
        this.pipelined = pipelined;
        this.vertx = vertx;
        this.pool = new SqlConnectionPool(connectionProvider, poolMetrics, (Handler<SqlConnectionPool.PooledConnection>)hook, afterAcquire, beforeRecycle, vertx, this.idleTimeout, this.maxLifetime, poolOptions.getMaxSize(), pipelined, poolOptions.getMaxWaitQueueSize(), poolOptions.getEventLoopSize());
        this.closeFuture = closeFuture;
        this.connectionInitializer = connectionInitializer;
    }

    private void initializeConnection(SqlConnectionPool.PooledConnection conn) {
        if (this.connectionInitializer != null) {
            ContextInternal current = this.vertx.getContext();
            SqlConnectionInternal wrapper = this.driver.wrapConnection(current, conn.factory(), conn);
            conn.init((Connection.Holder)((Object)wrapper));
            current.dispatch((Object)wrapper, this.connectionInitializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pool init() {
        this.closeFuture.add((Closeable)this);
        if ((this.idleTimeout > 0L || this.maxLifetime > 0L) && this.cleanerPeriod > 0L) {
            PoolImpl poolImpl = this;
            synchronized (poolImpl) {
                this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.runEviction());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEviction() {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            if (this.timerID == -1L) {
                return;
            }
            this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.runEviction());
        }
        this.pool.evict();
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    @Override
    protected ContextInternal context() {
        return this.vertx.getOrCreateContext();
    }

    @Override
    public Future<SqlConnection> getConnection() {
        ContextInternal current = this.vertx.getOrCreateContext();
        if (this.pipelined) {
            return current.failedFuture("Cannot acquire a connection on a pipelined pool");
        }
        PromiseInternal promise = current.promise();
        this.acquire(current, this.connectionTimeout, (Completable<SqlConnectionPool.PooledConnection>)promise);
        return promise.future().map(conn -> {
            SqlConnectionInternal wrapper = this.driver.wrapConnection(current, conn.factory(), (Connection)conn);
            conn.init((Connection.Holder)((Object)wrapper));
            return wrapper;
        });
    }

    public static <T> Future<@Nullable T> startPropagatableConnection(Pool pool, Function<SqlConnection, Future<@Nullable T>> function) {
        ContextInternal context = (ContextInternal)Vertx.currentContext();
        return pool.getConnection().onComplete(handler -> context.putLocal((Object)PROPAGATABLE_CONNECTION, handler.result())).flatMap(conn -> conn.begin().flatMap(tx -> ((Future)function.apply((SqlConnection)conn)).compose(res -> tx.commit().flatMap(v -> context.succeededFuture(res)), err -> {
            if (err instanceof TransactionRollbackException) {
                return context.failedFuture(err);
            }
            return tx.rollback().compose(v -> context.failedFuture(err), failure -> context.failedFuture(err));
        })).onComplete(ar -> conn.close().onComplete(v -> context.removeLocal((Object)PROPAGATABLE_CONNECTION))));
    }

    @Override
    public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
        return this.pool.execute(context, cmd);
    }

    private void acquire(ContextInternal context, long timeout, Completable<SqlConnectionPool.PooledConnection> completionHandler) {
        this.pool.acquire(context, timeout, completionHandler);
    }

    public void close(Promise<Void> completion) {
        this.doClose().onComplete(completion);
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.closeFuture.close((Promise)promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> doClose() {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        return this.pool.close();
    }

    @Override
    public int size() {
        return this.pool.size();
    }
}

