/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.CursorImpl;
import io.vertx.sqlclient.impl.QueryBase;
import io.vertx.sqlclient.impl.QueryExecutor;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.RowStreamImpl;
import io.vertx.sqlclient.internal.ArrayTuple;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.TupleInternal;
import io.vertx.sqlclient.internal.command.CloseCursorCommand;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandScheduler;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class PreparedStatementBase
implements PreparedStatement {
    private final Connection conn;
    private final ContextInternal context;
    private final boolean autoCommit;
    private final AtomicBoolean closed;

    public static PreparedStatement create(final Connection conn, ContextInternal context, final io.vertx.sqlclient.internal.PreparedStatement preparedStatement, final boolean autoCommit) {
        return new PreparedStatementBase(conn, context, autoCommit){

            @Override
            protected <R, F extends SqlResult<R>> void executeBatch(List<Tuple> argsList, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
                builder.executeBatchQuery((CommandScheduler)conn, null, preparedStatement, autoCommit, argsList, p);
            }

            @Override
            protected <R, F extends SqlResult<R>> void execute(Tuple args, int fetch, String cursorId, boolean suspended, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
                builder.executeExtendedQuery(conn, preparedStatement, null, autoCommit, args, fetch, cursorId, suspended, p);
            }

            @Override
            protected void close(Promise<Void> promise) {
                conn.schedule(new CloseStatementCommand(preparedStatement), promise);
            }

            @Override
            protected void closeCursor(String cursorId, Promise<Void> promise) {
                CloseCursorCommand cmd = new CloseCursorCommand(cursorId, preparedStatement);
                conn.schedule(cmd, promise);
            }

            @Override
            protected void readCursor(CursorImpl cursor, String id, boolean suspended, TupleInternal params, int count, PromiseInternal<RowSet<Row>> promise) {
                QueryExecutor<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> builder = new QueryExecutor<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>>(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
                cursor.result = builder.executeExtendedQuery(conn, preparedStatement, null, autoCommit, params, count, id, suspended, promise);
            }
        };
    }

    public static PreparedStatement create(final Connection conn, final ContextInternal context, final PrepareOptions options, final String sql, final boolean autoCommit) {
        return new PreparedStatementBase(conn, context, autoCommit){
            Future<io.vertx.sqlclient.internal.PreparedStatement> future;

            void withPreparedStatement(PrepareOptions options2, Tuple args, Handler<AsyncResult<io.vertx.sqlclient.internal.PreparedStatement>> handler) {
                if (context.inThread()) {
                    if (this.future == null) {
                        PromiseInternal promise = context.promise();
                        PrepareStatementCommand prepare = new PrepareStatementCommand(sql, options2, true, args.types());
                        conn.schedule(prepare, promise);
                        this.future = promise.future();
                    }
                    this.future.onComplete(handler);
                } else {
                    context.runOnContext(v -> this.withPreparedStatement(options2, args, handler));
                }
            }

            @Override
            protected <R, F extends SqlResult<R>> void executeBatch(List<Tuple> argsList, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
                this.withPreparedStatement(options, argsList.get(0), (Handler<AsyncResult<io.vertx.sqlclient.internal.PreparedStatement>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        builder.executeBatchQuery((CommandScheduler)conn, options, (io.vertx.sqlclient.internal.PreparedStatement)ar.result(), autoCommit, argsList, p);
                    } else {
                        p.fail(ar.cause());
                    }
                }));
            }

            @Override
            protected <R, F extends SqlResult<R>> void execute(Tuple args, int fetch, String cursorId, boolean suspended, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
                this.withPreparedStatement(options, args, (Handler<AsyncResult<io.vertx.sqlclient.internal.PreparedStatement>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        builder.executeExtendedQuery(conn, (io.vertx.sqlclient.internal.PreparedStatement)ar.result(), options, autoCommit, args, fetch, cursorId, suspended, p);
                    } else {
                        p.fail(ar.cause());
                    }
                }));
            }

            @Override
            protected void readCursor(CursorImpl cursor, String id, boolean suspended, TupleInternal params, int count, PromiseInternal<RowSet<Row>> promise) {
                this.withPreparedStatement(options, params, (Handler<AsyncResult<io.vertx.sqlclient.internal.PreparedStatement>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        QueryExecutor builder = new QueryExecutor(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
                        cursor.result = builder.executeExtendedQuery(conn, (io.vertx.sqlclient.internal.PreparedStatement)ar.result(), options, autoCommit, params, count, id, suspended, promise);
                    } else {
                        promise.fail(ar.cause());
                    }
                }));
            }

            @Override
            protected void close(Promise<Void> promise) {
                if (this.future != null) {
                    this.future.onComplete(ar -> {
                        if (ar.succeeded()) {
                            CloseStatementCommand cmd = new CloseStatementCommand((io.vertx.sqlclient.internal.PreparedStatement)ar.result());
                            conn.schedule(cmd, promise);
                        } else {
                            promise.fail(ar.cause());
                        }
                    });
                }
            }

            @Override
            protected void closeCursor(String cursorId, Promise<Void> promise) {
                if (this.future != null) {
                    this.future.onComplete(ar -> {
                        if (ar.succeeded()) {
                            CloseCursorCommand cmd = new CloseCursorCommand(cursorId, (io.vertx.sqlclient.internal.PreparedStatement)ar.result());
                            conn.schedule(cmd, promise);
                        } else {
                            promise.fail(ar.cause());
                        }
                    });
                } else {
                    promise.fail("Invalid");
                }
            }
        };
    }

    private PreparedStatementBase(Connection conn, ContextInternal context, boolean autoCommit) {
        this.conn = conn;
        this.context = context;
        this.autoCommit = autoCommit;
        this.closed = new AtomicBoolean();
    }

    protected abstract <R, F extends SqlResult<R>> void execute(Tuple var1, int var2, String var3, boolean var4, QueryExecutor<R, ?, F> var5, PromiseInternal<F> var6);

    protected abstract <R, F extends SqlResult<R>> void executeBatch(List<Tuple> var1, QueryExecutor<R, ?, F> var2, PromiseInternal<F> var3);

    protected abstract void close(Promise<Void> var1);

    protected abstract void closeCursor(String var1, Promise<Void> var2);

    protected abstract void readCursor(CursorImpl var1, String var2, boolean var3, TupleInternal var4, int var5, PromiseInternal<RowSet<Row>> var6);

    @Override
    public final PreparedQuery<RowSet<Row>> query() {
        return new PreparedStatementQuery(new QueryExecutor(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR));
    }

    @Override
    public final Cursor cursor(Tuple args) {
        return new CursorImpl(this, this.conn, this.context, this.autoCommit, (TupleInternal)args);
    }

    @Override
    public final Future<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            PromiseInternal promise = this.context.promise();
            this.close((Promise<Void>)promise);
            return promise.future();
        }
        return this.context.failedFuture("Already closed");
    }

    @Override
    public final RowStream<Row> createStream(int fetch, Tuple args) {
        return new RowStreamImpl(this, this.context, fetch, args);
    }

    private class PreparedStatementQuery<T, R extends SqlResult<T>>
    extends QueryBase<T, R>
    implements PreparedQuery<R> {
        public PreparedStatementQuery(QueryExecutor<T, ?, R> builder) {
            super(builder);
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(QueryExecutor<T2, ?, R2> builder) {
            return new PreparedStatementQuery<T2, R2>(builder);
        }

        @Override
        public <U> PreparedQuery<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
            return (PreparedQuery)super.collecting(collector);
        }

        @Override
        public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
            return (PreparedQuery)super.mapping(mapper);
        }

        @Override
        public Future<R> execute() {
            return this.execute(ArrayTuple.EMPTY);
        }

        @Override
        public Future<R> execute(Tuple args) {
            PromiseInternal promise = PreparedStatementBase.this.context.promise();
            PreparedStatementBase.this.execute(args, 0, null, false, this.builder, promise);
            return promise.future();
        }

        @Override
        public Future<R> executeBatch(List<Tuple> argsList) {
            if (argsList.isEmpty()) {
                return PreparedStatementBase.this.context.failedFuture("Empty batch");
            }
            PromiseInternal promise = PreparedStatementBase.this.context.promise();
            PreparedStatementBase.this.executeBatch(argsList, this.builder, promise);
            return promise.future();
        }
    }
}

