/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SqlConnection;
import io.vertx.ext.sql.UpdateResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlConnectionVertxEBProxy
implements SqlConnection {
    private Vertx _vertx;
    private String _address;
    private boolean closed;

    public SqlConnectionVertxEBProxy(Vertx vertx, String address) {
        this._vertx = vertx;
        this._address = address;
    }

    @Override
    public SqlConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("autoCommit", Boolean.valueOf(autoCommit));
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setAutoCommit");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public SqlConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("sql", sql);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "execute");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public SqlConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("sql", sql);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "query");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new ResultSet((JsonObject)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public SqlConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("sql", sql);
        _json.put("params", params);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "queryWithParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new ResultSet((JsonObject)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public SqlConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("sql", sql);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "update");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new UpdateResult((JsonObject)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public SqlConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("sql", sql);
        _json.put("params", params);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "updateWithParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)new UpdateResult((JsonObject)((Message)res.result()).body())));
            }
        });
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        this.closed = true;
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "close");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
    }

    @Override
    public SqlConnection commit(Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "commit");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public SqlConnection rollback(Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "rollback");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    private List<Character> convertToListChar(JsonArray arr) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            list.add(Character.valueOf((char)jobj.intValue()));
        }
        return list;
    }

    private Set<Character> convertToSetChar(JsonArray arr) {
        HashSet<Character> set = new HashSet<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            set.add(Character.valueOf((char)jobj.intValue()));
        }
        return set;
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

