/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SqlConnection;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.serviceproxy.ProxyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlConnectionVertxProxyHandler
extends ProxyHandler {
    private final Vertx vertx;
    private final SqlConnection service;
    private final String address;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public SqlConnectionVertxProxyHandler(Vertx vertx, SqlConnection service, String address, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.address = address;
        this.timeoutSeconds = timeoutSeconds;
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.service.close((Handler<AsyncResult<Void>>)((Handler)done -> {}));
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        JsonObject json = (JsonObject)msg.body();
        String action = msg.headers().get("action");
        if (action == null) {
            throw new IllegalStateException("action not specified");
        }
        this.accessed();
        switch (action) {
            case "setAutoCommit": {
                this.service.setAutoCommit((Boolean)json.getValue("autoCommit"), this.createHandler(msg));
                break;
            }
            case "execute": {
                this.service.execute((String)json.getValue("sql"), this.createHandler(msg));
                break;
            }
            case "query": {
                this.service.query((String)json.getValue("sql"), (Handler<AsyncResult<ResultSet>>)((Handler)res -> {
                    if (res.failed()) {
                        msg.fail(-1, res.cause().getMessage());
                    } else {
                        msg.reply((Object)((ResultSet)res.result()).toJson());
                    }
                }));
                break;
            }
            case "queryWithParams": {
                this.service.queryWithParams((String)json.getValue("sql"), (JsonArray)json.getValue("params"), (Handler<AsyncResult<ResultSet>>)((Handler)res -> {
                    if (res.failed()) {
                        msg.fail(-1, res.cause().getMessage());
                    } else {
                        msg.reply((Object)((ResultSet)res.result()).toJson());
                    }
                }));
                break;
            }
            case "update": {
                this.service.update((String)json.getValue("sql"), (Handler<AsyncResult<UpdateResult>>)((Handler)res -> {
                    if (res.failed()) {
                        msg.fail(-1, res.cause().getMessage());
                    } else {
                        msg.reply((Object)((UpdateResult)res.result()).toJson());
                    }
                }));
                break;
            }
            case "updateWithParams": {
                this.service.updateWithParams((String)json.getValue("sql"), (JsonArray)json.getValue("params"), (Handler<AsyncResult<UpdateResult>>)((Handler)res -> {
                    if (res.failed()) {
                        msg.fail(-1, res.cause().getMessage());
                    } else {
                        msg.reply((Object)((UpdateResult)res.result()).toJson());
                    }
                }));
                break;
            }
            case "close": {
                this.service.close(this.createHandler(msg));
                this.close();
                break;
            }
            case "commit": {
                this.service.commit(this.createHandler(msg));
                break;
            }
            case "rollback": {
                this.service.rollback(this.createHandler(msg));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid action: " + action);
            }
        }
    }

    private <T> Handler<AsyncResult<T>> createHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply(res.result());
            }
        };
    }

    private <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    private <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    private Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

