/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class ResultSet {
    private List<String> columnNames;
    private List<JsonArray> results;
    private List<JsonObject> rows;

    public ResultSet() {
    }

    public ResultSet(ResultSet other) {
        this.columnNames = other.columnNames;
        this.results = other.results;
    }

    public ResultSet(List<String> columnNames, List<JsonArray> results) {
        this.columnNames = columnNames;
        this.results = results;
    }

    public ResultSet(JsonObject json) {
        JsonArray arr = json.getJsonArray("columnNames");
        if (arr != null) {
            this.columnNames = arr.getList();
        }
        if ((arr = json.getJsonArray("results")) != null) {
            this.results = arr.getList();
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.put("columnNames", new JsonArray(this.columnNames));
        obj.put("results", new JsonArray(this.results));
        return obj;
    }

    public List<JsonArray> getResults() {
        return this.results;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<JsonObject> getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList<JsonObject>(this.results.size());
            int cols = this.columnNames.size();
            for (JsonArray result : this.results) {
                JsonObject row = new JsonObject();
                for (int i = 0; i < cols; ++i) {
                    row.put(this.columnNames.get(i), result.getValue(i));
                }
                this.rows.add(row);
            }
        }
        return this.rows;
    }

    public int getNumRows() {
        return this.results.size();
    }

    public int getNumColumns() {
        return this.columnNames.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultSet resultSet = (ResultSet)o;
        if (this.columnNames != null ? !this.columnNames.equals(resultSet.columnNames) : resultSet.columnNames != null) {
            return false;
        }
        return !(this.results != null ? !this.results.equals(resultSet.results) : resultSet.results != null);
    }

    public int hashCode() {
        int result = this.columnNames != null ? this.columnNames.hashCode() : 0;
        result = 31 * result + (this.results != null ? this.results.hashCode() : 0);
        return result;
    }
}

