/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import java.util.List;
import rx.Observable;

public class SQLConnection {
    final io.vertx.ext.sql.SQLConnection delegate;

    public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.setAutoCommit(autoCommit, resultHandler);
        return this;
    }

    public Observable<Void> setAutoCommitObservable(boolean autoCommit) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.setAutoCommit(autoCommit, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.execute(sql, resultHandler);
        return this;
    }

    public Observable<Void> executeObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.execute(sql, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.query(sql, resultHandler);
        return this;
    }

    public Observable<ResultSet> queryObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.query(sql, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.queryWithParams(sql, params, resultHandler);
        return this;
    }

    public Observable<ResultSet> queryWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queryWithParams(sql, params, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.delegate.update(sql, resultHandler);
        return this;
    }

    public Observable<UpdateResult> updateObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.update(sql, (Handler<AsyncResult<UpdateResult>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.delegate.updateWithParams(sql, params, resultHandler);
        return this;
    }

    public Observable<UpdateResult> updateWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.updateWithParams(sql, params, (Handler<AsyncResult<UpdateResult>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.call(sql, resultHandler);
        return this;
    }

    public Observable<ResultSet> callObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.call(sql, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.callWithParams(sql, params, outputs, resultHandler);
        return this;
    }

    public Observable<ResultSet> callWithParamsObservable(String sql, JsonArray params, JsonArray outputs) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.callWithParams(sql, params, outputs, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.close((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public void close() {
        this.delegate.close();
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
        return this;
    }

    public Observable<Void> commitObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commit((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
        return this;
    }

    public Observable<Void> rollbackObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rollback((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public SQLConnection setQueryTimeout(int timeoutInSeconds) {
        this.delegate.setQueryTimeout(timeoutInSeconds);
        return this;
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batch(sqlStatements, handler);
        return this;
    }

    public Observable<List<Integer>> batchObservable(List<String> sqlStatements) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batch(sqlStatements, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batchWithParams(sqlStatement, args, handler);
        return this;
    }

    public Observable<List<Integer>> batchWithParamsObservable(String sqlStatement, List<JsonArray> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batchWithParams(sqlStatement, args, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
        return this;
    }

    public Observable<List<Integer>> batchCallableWithParamsObservable(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batchCallableWithParams(sqlStatement, inArgs, outArgs, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
        this.delegate.setTransactionIsolation(isolation, handler);
        return this;
    }

    public Observable<Void> setTransactionIsolationObservable(TransactionIsolation isolation) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setTransactionIsolation(isolation, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        this.delegate.getTransactionIsolation(handler);
        return this;
    }

    public Observable<TransactionIsolation> getTransactionIsolationObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getTransactionIsolation((Handler<AsyncResult<TransactionIsolation>>)handler.toHandler());
        return handler;
    }

    public static SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
        return arg != null ? new SQLConnection(arg) : null;
    }
}

