/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;

public class ResultSetConverter {
    public static void fromJson(JsonObject json, ResultSet obj) {
        ArrayList<String> list;
        if (json.getValue("columnNames") instanceof JsonArray) {
            list = new ArrayList<String>();
            json.getJsonArray("columnNames").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setColumnNames(list);
        }
        if (json.getValue("next") instanceof JsonObject) {
            obj.setNext(new ResultSet((JsonObject)json.getValue("next")));
        }
        if (json.getValue("output") instanceof JsonArray) {
            obj.setOutput(((JsonArray)json.getValue("output")).copy());
        }
        if (json.getValue("results") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("results").forEach(item -> {
                if (item instanceof JsonArray) {
                    list.add((String)((JsonArray)item).copy());
                }
            });
            obj.setResults(list);
        }
        if (json.getValue("rows") instanceof JsonArray) {
            // empty if block
        }
    }

    public static void toJson(ResultSet obj, JsonObject json) {
        JsonArray array;
        if (obj.getColumnNames() != null) {
            array = new JsonArray();
            obj.getColumnNames().forEach(item -> array.add(item));
            json.put("columnNames", array);
        }
        if (obj.getNext() != null) {
            json.put("next", obj.getNext().toJson());
        }
        json.put("numColumns", Integer.valueOf(obj.getNumColumns()));
        json.put("numRows", Integer.valueOf(obj.getNumRows()));
        if (obj.getOutput() != null) {
            json.put("output", obj.getOutput());
        }
        if (obj.getResults() != null) {
            array = new JsonArray();
            obj.getResults().forEach(item -> array.add(item));
            json.put("results", array);
        }
        if (obj.getRows() != null) {
            array = new JsonArray();
            obj.getRows().forEach(item -> array.add(item));
            json.put("rows", array);
        }
    }
}

