/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A common asynchronous client interface for interacting with SQL compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.sql.SQLClient.class)
public class SQLClient {

  public static final io.vertx.lang.reactivex.TypeArg<SQLClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new SQLClient((io.vertx.ext.sql.SQLClient) obj),
    SQLClient::getDelegate
  );

  private final io.vertx.ext.sql.SQLClient delegate;
  
  public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.sql.SQLClient getDelegate() {
    return delegate;
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @param handler the handler which is called when the <code>JdbcConnection</code> object is ready for use.
   * @return 
   */
  public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.ext.sql.SQLConnection>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(SQLConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @return 
   */
  public Single<SQLConnection> rxGetConnection() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<SQLConnection>(handler -> {
      getConnection(handler);
    });
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @param completionHandler the handler that will be called when close is complete
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @return 
   */
  public Completable rxClose() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Close the client
   */
  public void close() { 
    delegate.close();
  }


  public static  SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
    return arg != null ? new SQLClient(arg) : null;
  }
}
