/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.sql;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
 * close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
 * full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
 * resources.
 *
 * The interface is minimal in order to support all SQL clients not just JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLRowStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.sql.SQLRowStream.class)
public class SQLRowStream implements ReadStream<JsonArray> {

  public static final io.vertx.lang.rxjava.TypeArg<SQLRowStream> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new SQLRowStream((io.vertx.ext.sql.SQLRowStream) obj),
    SQLRowStream::getDelegate
  );

  private final io.vertx.ext.sql.SQLRowStream delegate;
  
  public SQLRowStream(io.vertx.ext.sql.SQLRowStream delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.sql.SQLRowStream getDelegate() {
    return delegate;
  }

  private rx.Observable<JsonArray> observable;

  public synchronized rx.Observable<JsonArray> toObservable() {
    if (observable == null) {
      observable = io.vertx.rx.java.RxHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public SQLRowStream exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public SQLRowStream handler(Handler<JsonArray> handler) { 
    delegate.handler(handler);
    return this;
  }

  public SQLRowStream pause() { 
    delegate.pause();
    return this;
  }

  public SQLRowStream resume() { 
    delegate.resume();
    return this;
  }

  public SQLRowStream endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Will convert the column name to the json array index.
   * @param name the column name
   * @return the json array index
   */
  public int column(String name) { 
    int ret = delegate.column(name);
    return ret;
  }

  /**
   * Returns all column names available in the underlying resultset. One needs to carefully use this method since in
   * contrast to the singular version it does not perform case insensitive lookups or takes alias in consideration on
   * the column names.
   * @return the list of columns names returned by the query
   */
  public List<String> columns() { 
    List<String> ret = delegate.columns();
    return ret;
  }

  /**
   * Event handler when a resultset is closed. This is useful to request for more results.
   * @param handler called when the current result set is closed
   * @return 
   */
  public SQLRowStream resultSetClosedHandler(Handler<Void> handler) { 
    delegate.resultSetClosedHandler(handler);
    return this;
  }

  /**
   * Request for more results if available
   */
  public void moreResults() { 
    delegate.moreResults();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @param handler called when the stream/underlying cursor(s) is(are) closed
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(handler.toHandler());
    return handler;
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }


  public static  SQLRowStream newInstance(io.vertx.ext.sql.SQLRowStream arg) {
    return arg != null ? new SQLRowStream(arg) : null;
  }
}
