/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A common asynchronous client interface for interacting with SQL compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.sql.SQLClient.class)
public class SQLClient implements SQLOperations {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLClient that = (SQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<SQLClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new SQLClient((io.vertx.ext.sql.SQLClient) obj),
    SQLClient::getDelegate
  );

  private final io.vertx.ext.sql.SQLClient delegate;
  
  public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.sql.SQLClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return 
   */
  public Single<JsonArray> rxQuerySingle(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingle(sql, handler);
    });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return 
   */
  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @param handler the handler which is called when the <code>JdbcConnection</code> object is ready for use.
   * @return 
   */
  public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.ext.sql.SQLConnection>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(SQLConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @return 
   */
  public Single<SQLConnection> rxGetConnection() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<SQLConnection>(handler -> {
      getConnection(handler);
    });
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @param handler the handler that will be called when close is complete
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @return 
   */
  public Completable rxClose() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Close the client
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
   * statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) { 
    delegate.query(sql, handler);
    return this;
  }

  /**
   * Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
   * statement and returns it back after the execution.
   * @param sql the statement to execute
   * @return 
   */
  public Single<ResultSet> rxQuery(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<ResultSet>(handler -> {
      query(sql, handler);
    });
  }

  /**
   * Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
   * prepared statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param arguments the arguments to the statement
   * @param handler the result handler
   * @return self
   */
  public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) { 
    delegate.queryWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
   * prepared statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param arguments the arguments to the statement
   * @return 
   */
  public Single<ResultSet> rxQueryWithParams(String sql, JsonArray arguments) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<ResultSet>(handler -> {
      queryWithParams(sql, arguments, handler);
    });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param handler the handler which is called once the operation completes.
   * @return 
   */
  public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) { 
    delegate.update(sql, handler);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public Single<UpdateResult> rxUpdate(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<UpdateResult>(handler -> {
      update(sql, handler);
    });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes.
   * @return 
   */
  public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) { 
    delegate.updateWithParams(sql, params, handler);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<UpdateResult>(handler -> {
      updateWithParams(sql, params, handler);
    });
  }


  public static  SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
    return arg != null ? new SQLClient(arg) : null;
  }
}
