/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.UpdateResult;

@VertxGen
public interface SQLClient
extends SQLOperations {
    @Fluent
    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> var1);

    public void close(Handler<AsyncResult<Void>> var1);

    public void close();

    @Override
    @Fluent
    default public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.query(sql, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)query.result()));
                            }
                        }));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.queryWithParams(sql, arguments, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)query.result()));
                            }
                        }));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.update(sql, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)query.result()));
                            }
                        }));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.updateWithParams(sql, params, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)query.result()));
                            }
                        }));
                    }
                });
            }
        }));
        return this;
    }
}

