/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.sql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.sql.SQLOperations;
import io.vertx.rxjava.ext.sql.SQLRowStream;
import java.util.List;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.sql.SQLConnection.class)
public class SQLConnection
implements SQLOperations {
    public static final TypeArg<SQLConnection> __TYPE_ARG = new TypeArg(obj -> new SQLConnection((io.vertx.ext.sql.SQLConnection)obj), SQLConnection::getDelegate);
    private final io.vertx.ext.sql.SQLConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLConnection that = (SQLConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
        this.delegate = delegate;
    }

    @Override
    public io.vertx.ext.sql.SQLConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingle(sql, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> querySingleObservable(String sql) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxQuerySingle(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingleWithParams(sql, arguments, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public SQLConnection setOptions(SQLOptions options) {
        this.delegate.setOptions(options);
        return this;
    }

    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.setAutoCommit(autoCommit, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> setAutoCommitObservable(boolean autoCommit) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.setAutoCommit(autoCommit, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxSetAutoCommit(boolean autoCommit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setAutoCommit(autoCommit, (Handler<AsyncResult<Void>>)fut)));
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.execute(sql, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> executeObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.execute(sql, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExecute(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.execute(sql, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.query(sql, (Handler)resultHandler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> queryObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.query(sql, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<ResultSet> rxQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler)fut)));
    }

    public SQLConnection queryStream(String sql, final Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<SQLRowStream> queryStreamObservable(String sql) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.queryStream(sql, (Handler<AsyncResult<SQLRowStream>>)handler.toHandler());
        return handler;
    }

    public Single<SQLRowStream> rxQueryStream(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queryStream(sql, (Handler<AsyncResult<SQLRowStream>>)fut)));
    }

    @Override
    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.queryWithParams(sql, params, (Handler)resultHandler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> queryWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queryWithParams(sql, params, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<ResultSet> rxQueryWithParams(String sql, JsonArray params) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queryWithParams(sql, params, (Handler)fut)));
    }

    public SQLConnection queryStreamWithParams(String sql, JsonArray params, final Handler<AsyncResult<SQLRowStream>> handler) {
        this.delegate.queryStreamWithParams(sql, params, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<SQLRowStream> queryStreamWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.queryStreamWithParams(sql, params, (Handler<AsyncResult<SQLRowStream>>)handler.toHandler());
        return handler;
    }

    public Single<SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queryStreamWithParams(sql, params, (Handler<AsyncResult<SQLRowStream>>)fut)));
    }

    @Override
    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.delegate.update(sql, (Handler)resultHandler);
        return this;
    }

    @Deprecated
    public Observable<UpdateResult> updateObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.update(sql, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<UpdateResult> rxUpdate(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.update(sql, (Handler)fut)));
    }

    @Override
    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.delegate.updateWithParams(sql, params, (Handler)resultHandler);
        return this;
    }

    @Deprecated
    public Observable<UpdateResult> updateWithParamsObservable(String sql, JsonArray params) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.updateWithParams(sql, params, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateWithParams(sql, params, (Handler)fut)));
    }

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.call(sql, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> callObservable(String sql) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.call(sql, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<ResultSet> rxCall(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.call(sql, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.callWithParams(sql, params, outputs, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<ResultSet> callWithParamsObservable(String sql, JsonArray params, JsonArray outputs) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.callWithParams(sql, params, outputs, (Handler<AsyncResult<ResultSet>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.callWithParams(sql, params, outputs, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.close((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> commitObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commit((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxCommit() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commit((Handler<AsyncResult<Void>>)fut)));
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> rollbackObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rollback((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxRollback() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rollback((Handler<AsyncResult<Void>>)fut)));
    }

    public SQLConnection setQueryTimeout(int timeoutInSeconds) {
        this.delegate.setQueryTimeout(timeoutInSeconds);
        return this;
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batch(sqlStatements, handler);
        return this;
    }

    @Deprecated
    public Observable<List<Integer>> batchObservable(List<String> sqlStatements) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batch(sqlStatements, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public Single<List<Integer>> rxBatch(List<String> sqlStatements) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.batch(sqlStatements, (Handler<AsyncResult<List<Integer>>>)fut)));
    }

    public SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batchWithParams(sqlStatement, args, handler);
        return this;
    }

    @Deprecated
    public Observable<List<Integer>> batchWithParamsObservable(String sqlStatement, List<JsonArray> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batchWithParams(sqlStatement, args, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public Single<List<Integer>> rxBatchWithParams(String sqlStatement, List<JsonArray> args) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.batchWithParams(sqlStatement, args, (Handler<AsyncResult<List<Integer>>>)fut)));
    }

    public SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        this.delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
        return this;
    }

    @Deprecated
    public Observable<List<Integer>> batchCallableWithParamsObservable(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.batchCallableWithParams(sqlStatement, inArgs, outArgs, (Handler<AsyncResult<List<Integer>>>)handler.toHandler());
        return handler;
    }

    public Single<List<Integer>> rxBatchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.batchCallableWithParams(sqlStatement, inArgs, outArgs, (Handler<AsyncResult<List<Integer>>>)fut)));
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
        this.delegate.setTransactionIsolation(isolation, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> setTransactionIsolationObservable(TransactionIsolation isolation) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setTransactionIsolation(isolation, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSetTransactionIsolation(TransactionIsolation isolation) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setTransactionIsolation(isolation, (Handler<AsyncResult<Void>>)fut)));
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        this.delegate.getTransactionIsolation(handler);
        return this;
    }

    @Deprecated
    public Observable<TransactionIsolation> getTransactionIsolationObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getTransactionIsolation((Handler<AsyncResult<TransactionIsolation>>)handler.toHandler());
        return handler;
    }

    public Single<TransactionIsolation> rxGetTransactionIsolation() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getTransactionIsolation((Handler<AsyncResult<TransactionIsolation>>)fut)));
    }

    public static SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
        return arg != null ? new SQLConnection(arg) : null;
    }
}

