/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultMaybe;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.reactivex.ext.sql.SQLOperations;

@RxGen(value=io.vertx.ext.sql.SQLClient.class)
public class SQLClient
implements SQLOperations {
    public static final TypeArg<SQLClient> __TYPE_ARG = new TypeArg(obj -> new SQLClient((io.vertx.ext.sql.SQLClient)obj), SQLClient::getDelegate);
    private final io.vertx.ext.sql.SQLClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLClient that = (SQLClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public io.vertx.ext.sql.SQLClient getDelegate() {
        return this.delegate;
    }

    @Override
    public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingle(sql, handler);
        return this;
    }

    public Maybe<JsonArray> rxQuerySingle(String sql) {
        return new AsyncResultMaybe(handler -> this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)handler));
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingleWithParams(sql, arguments, handler);
        return this;
    }

    public Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) {
        return new AsyncResultMaybe(handler -> this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public SQLClient getConnection(final Handler<AsyncResult<SQLConnection>> handler) {
        this.delegate.getConnection(new Handler<AsyncResult<io.vertx.ext.sql.SQLConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.sql.SQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SQLConnection.newInstance((io.vertx.ext.sql.SQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<SQLConnection> rxGetConnection() {
        return new AsyncResultSingle(handler -> this.getConnection((Handler<AsyncResult<SQLConnection>>)handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    @Override
    public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.query(sql, (Handler)handler);
        return this;
    }

    public Single<ResultSet> rxQuery(String sql) {
        return new AsyncResultSingle(handler -> this.query(sql, (Handler)handler));
    }

    @Override
    public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.queryWithParams(sql, arguments, (Handler)handler);
        return this;
    }

    public Single<ResultSet> rxQueryWithParams(String sql, JsonArray arguments) {
        return new AsyncResultSingle(handler -> this.queryWithParams(sql, arguments, (Handler)handler));
    }

    @Override
    public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.update(sql, (Handler)handler);
        return this;
    }

    public Single<UpdateResult> rxUpdate(String sql) {
        return new AsyncResultSingle(handler -> this.update(sql, (Handler)handler));
    }

    @Override
    public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.delegate.updateWithParams(sql, params, (Handler)handler);
        return this;
    }

    public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) {
        return new AsyncResultSingle(handler -> this.updateWithParams(sql, params, (Handler)handler));
    }

    @Override
    public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.call(sql, (Handler)handler);
        return this;
    }

    public Single<ResultSet> rxCall(String sql) {
        return new AsyncResultSingle(handler -> this.call(sql, (Handler)handler));
    }

    @Override
    public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.delegate.callWithParams(sql, params, outputs, (Handler)handler);
        return this;
    }

    public Single<ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) {
        return new AsyncResultSingle(handler -> this.callWithParams(sql, params, outputs, (Handler)handler));
    }

    public static SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
        return arg != null ? new SQLClient(arg) : null;
    }
}

