/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import java.util.List;

@VertxGen(concrete=false)
public interface SQLOperations {
    @Fluent
    public SQLOperations query(String var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public SQLOperations queryWithParams(String var1, JsonArray var2, Handler<AsyncResult<ResultSet>> var3);

    @Fluent
    default public SQLOperations querySingle(String sql, Handler<AsyncResult<@Nullable JsonArray>> handler) {
        return this.query(sql, (Handler<AsyncResult<ResultSet>>)((Handler)execute -> {
            if (execute.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)execute.cause()));
            } else {
                ResultSet rs = (ResultSet)execute.result();
                if (rs == null) {
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    List<JsonArray> results = rs.getResults();
                    if (results == null) {
                        handler.handle((Object)Future.succeededFuture());
                    } else if (results.size() > 0) {
                        handler.handle((Object)Future.succeededFuture((Object)results.get(0)));
                    } else {
                        handler.handle((Object)Future.succeededFuture());
                    }
                }
            }
        }));
    }

    @Fluent
    default public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<@Nullable JsonArray>> handler) {
        return this.queryWithParams(sql, arguments, (Handler<AsyncResult<ResultSet>>)((Handler)execute -> {
            if (execute.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)execute.cause()));
            } else {
                ResultSet rs = (ResultSet)execute.result();
                if (rs == null) {
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    List<JsonArray> results = rs.getResults();
                    if (results == null) {
                        handler.handle((Object)Future.succeededFuture());
                    } else if (results.size() > 0) {
                        handler.handle((Object)Future.succeededFuture((Object)results.get(0)));
                    } else {
                        handler.handle((Object)Future.succeededFuture());
                    }
                }
            }
        }));
    }

    @Fluent
    public SQLOperations update(String var1, Handler<AsyncResult<UpdateResult>> var2);

    @Fluent
    public SQLOperations updateWithParams(String var1, JsonArray var2, Handler<AsyncResult<UpdateResult>> var3);

    @Fluent
    public SQLOperations call(String var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public SQLOperations callWithParams(String var1, JsonArray var2, JsonArray var3, Handler<AsyncResult<ResultSet>> var4);
}

