/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.FetchDirection;
import io.vertx.ext.sql.ResultSetConcurrency;
import io.vertx.ext.sql.ResultSetType;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;

public class SQLOptionsConverter {
    public static void fromJson(JsonObject json, SQLOptions obj) {
        if (json.getValue("autoGeneratedKeys") instanceof Boolean) {
            obj.setAutoGeneratedKeys((Boolean)json.getValue("autoGeneratedKeys"));
        }
        if (json.getValue("autoGeneratedKeysIndexes") instanceof JsonArray) {
            obj.setAutoGeneratedKeysIndexes(((JsonArray)json.getValue("autoGeneratedKeysIndexes")).copy());
        }
        if (json.getValue("catalog") instanceof String) {
            obj.setCatalog((String)json.getValue("catalog"));
        }
        if (json.getValue("fetchDirection") instanceof String) {
            obj.setFetchDirection(FetchDirection.valueOf((String)json.getValue("fetchDirection")));
        }
        if (json.getValue("fetchSize") instanceof Number) {
            obj.setFetchSize(((Number)json.getValue("fetchSize")).intValue());
        }
        if (json.getValue("queryTimeout") instanceof Number) {
            obj.setQueryTimeout(((Number)json.getValue("queryTimeout")).intValue());
        }
        if (json.getValue("readOnly") instanceof Boolean) {
            obj.setReadOnly((Boolean)json.getValue("readOnly"));
        }
        if (json.getValue("resultSetConcurrency") instanceof String) {
            obj.setResultSetConcurrency(ResultSetConcurrency.valueOf((String)json.getValue("resultSetConcurrency")));
        }
        if (json.getValue("resultSetType") instanceof String) {
            obj.setResultSetType(ResultSetType.valueOf((String)json.getValue("resultSetType")));
        }
        if (json.getValue("schema") instanceof String) {
            obj.setSchema((String)json.getValue("schema"));
        }
        if (json.getValue("transactionIsolation") instanceof String) {
            obj.setTransactionIsolation(TransactionIsolation.valueOf((String)json.getValue("transactionIsolation")));
        }
    }

    public static void toJson(SQLOptions obj, JsonObject json) {
        json.put("autoGeneratedKeys", Boolean.valueOf(obj.isAutoGeneratedKeys()));
        if (obj.getAutoGeneratedKeysIndexes() != null) {
            json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
        }
        if (obj.getCatalog() != null) {
            json.put("catalog", obj.getCatalog());
        }
        if (obj.getFetchDirection() != null) {
            json.put("fetchDirection", obj.getFetchDirection().name());
        }
        json.put("fetchSize", Integer.valueOf(obj.getFetchSize()));
        json.put("queryTimeout", Integer.valueOf(obj.getQueryTimeout()));
        json.put("readOnly", Boolean.valueOf(obj.isReadOnly()));
        if (obj.getResultSetConcurrency() != null) {
            json.put("resultSetConcurrency", obj.getResultSetConcurrency().name());
        }
        if (obj.getResultSetType() != null) {
            json.put("resultSetType", obj.getResultSetType().name());
        }
        if (obj.getSchema() != null) {
            json.put("schema", obj.getSchema());
        }
        if (obj.getTransactionIsolation() != null) {
            json.put("transactionIsolation", obj.getTransactionIsolation().name());
        }
    }
}

