/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.util.List;

final class HandlerUtil {
    HandlerUtil() {
    }

    static Handler<AsyncResult<ResultSet>> handleResultSetSingleRow(Handler<AsyncResult<@Nullable JsonArray>> handler) {
        return ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                ResultSet rs = (ResultSet)ar.result();
                if (rs == null) {
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    List<JsonArray> results = rs.getResults();
                    if (results == null) {
                        handler.handle((Object)Future.succeededFuture());
                    } else if (results.size() > 0) {
                        handler.handle((Object)Future.succeededFuture((Object)results.get(0)));
                    } else {
                        handler.handle((Object)Future.succeededFuture());
                    }
                }
            }
        };
    }

    static <T> Handler<AsyncResult<T>> closeAndHandleResult(SQLConnection conn, Handler<AsyncResult<T>> handler) {
        return ar -> {
            if (ar.failed()) {
                conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                    if (close.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                }));
            } else {
                conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                    if (close.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                    } else {
                        handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                    }
                }));
            }
        };
    }
}

