/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.FetchDirection;
import io.vertx.ext.sql.ResultSetConcurrency;
import io.vertx.ext.sql.ResultSetType;
import io.vertx.ext.sql.SQLOptionsConverter;
import io.vertx.ext.sql.TransactionIsolation;
import java.util.Map;

@DataObject(generateConverter=true)
public class SQLOptions {
    private boolean readOnly;
    private String catalog;
    private TransactionIsolation transactionIsolation;
    private ResultSetType resultSetType;
    private ResultSetConcurrency resultSetConcurrency;
    private boolean autoGeneratedKeys = true;
    private JsonArray autoGeneratedKeysIndexes;
    private String schema;
    private int queryTimeout;
    private int maxRows;
    private FetchDirection fetchDirection;
    private int fetchSize;

    public SQLOptions() {
    }

    public SQLOptions(SQLOptions other) {
        this.readOnly = other.isReadOnly();
        this.catalog = other.getCatalog();
        this.transactionIsolation = other.getTransactionIsolation();
        this.resultSetType = other.getResultSetType();
        this.resultSetConcurrency = other.getResultSetConcurrency();
        this.autoGeneratedKeys = other.isAutoGeneratedKeys();
        this.autoGeneratedKeysIndexes = other.getAutoGeneratedKeysIndexes();
        this.schema = other.getSchema();
        this.queryTimeout = other.getQueryTimeout();
        this.maxRows = other.getMaxRows();
        this.fetchDirection = other.getFetchDirection();
        this.fetchSize = other.getFetchSize();
    }

    public SQLOptions(JsonObject json) {
        SQLOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public SQLOptions setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SQLOptions setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public SQLOptions setTransactionIsolation(TransactionIsolation transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        return this;
    }

    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public SQLOptions setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
        return this;
    }

    public ResultSetConcurrency getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public SQLOptions setResultSetConcurrency(ResultSetConcurrency resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
        return this;
    }

    public boolean isAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public SQLOptions setAutoGeneratedKeys(boolean autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SQLOptions setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public SQLOptions setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public SQLOptions setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public FetchDirection getFetchDirection() {
        return this.fetchDirection;
    }

    public SQLOptions setFetchDirection(FetchDirection fetchDirection) {
        this.fetchDirection = fetchDirection;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public SQLOptions setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JsonArray getAutoGeneratedKeysIndexes() {
        return this.autoGeneratedKeysIndexes;
    }

    public SQLOptions setAutoGeneratedKeysIndexes(JsonArray autoGeneratedKeysIndexes) {
        this.autoGeneratedKeysIndexes = autoGeneratedKeysIndexes;
        return this;
    }
}

