/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonDecoder;
import io.vertx.ext.sql.FetchDirection;
import io.vertx.ext.sql.ResultSetConcurrency;
import io.vertx.ext.sql.ResultSetType;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;
import java.util.Map;

public class SQLOptionsConverter
implements JsonDecoder<SQLOptions, JsonObject> {
    public static final SQLOptionsConverter INSTANCE = new SQLOptionsConverter();

    public SQLOptions decode(JsonObject value) {
        return value != null ? new SQLOptions(value) : null;
    }

    public Class<SQLOptions> getTargetClass() {
        return SQLOptions.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, SQLOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "autoGeneratedKeys": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoGeneratedKeys((Boolean)member.getValue());
                    break;
                }
                case "autoGeneratedKeysIndexes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setAutoGeneratedKeysIndexes(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "catalog": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCatalog((String)member.getValue());
                    break;
                }
                case "fetchDirection": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFetchDirection(FetchDirection.valueOf((String)member.getValue()));
                    break;
                }
                case "fetchSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFetchSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "readOnly": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReadOnly((Boolean)member.getValue());
                    break;
                }
                case "resultSetConcurrency": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResultSetConcurrency(ResultSetConcurrency.valueOf((String)member.getValue()));
                    break;
                }
                case "resultSetType": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResultSetType(ResultSetType.valueOf((String)member.getValue()));
                    break;
                }
                case "schema": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSchema((String)member.getValue());
                    break;
                }
                case "transactionIsolation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTransactionIsolation(TransactionIsolation.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(SQLOptions obj, JsonObject json) {
        SQLOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(SQLOptions obj, Map<String, Object> json) {
        json.put("autoGeneratedKeys", obj.isAutoGeneratedKeys());
        if (obj.getAutoGeneratedKeysIndexes() != null) {
            json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
        }
        if (obj.getCatalog() != null) {
            json.put("catalog", obj.getCatalog());
        }
        if (obj.getFetchDirection() != null) {
            json.put("fetchDirection", obj.getFetchDirection().name());
        }
        json.put("fetchSize", obj.getFetchSize());
        json.put("queryTimeout", obj.getQueryTimeout());
        json.put("readOnly", obj.isReadOnly());
        if (obj.getResultSetConcurrency() != null) {
            json.put("resultSetConcurrency", obj.getResultSetConcurrency().name());
        }
        if (obj.getResultSetType() != null) {
            json.put("resultSetType", obj.getResultSetType().name());
        }
        if (obj.getSchema() != null) {
            json.put("schema", obj.getSchema());
        }
        if (obj.getTransactionIsolation() != null) {
            json.put("transactionIsolation", obj.getTransactionIsolation().name());
        }
    }
}

