/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;

public class InfinispanSessionStoreImpl
implements InfinispanSessionStore {
    private VertxInternal vertx;
    private JsonObject options;
    private VertxContextPRNG random;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<String, byte[]> sessions;

    public SessionStore init(Vertx vertx, JsonObject options) {
        return this.init(vertx, options, null);
    }

    public SessionStore init(Vertx vertx, JsonObject options, RemoteCacheManager remoteCacheManager) {
        this.vertx = (VertxInternal)vertx;
        this.options = Objects.requireNonNull(options, "options are required");
        this.random = VertxContextPRNG.current((Vertx)vertx);
        if (remoteCacheManager != null) {
            this.remoteCacheManager = remoteCacheManager;
        } else {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            JsonArray servers = Objects.requireNonNull(options.getJsonArray("servers"), "servers list is required");
            for (Object object : servers) {
                if (!(object instanceof JsonObject)) continue;
                JsonObject server = (JsonObject)object;
                InfinispanSessionStoreImpl.configure(builder.addServer(), server);
            }
            this.remoteCacheManager = new RemoteCacheManager(builder.build());
        }
        String cacheName = options.getString("cacheName", "vertx-web.sessions");
        this.sessions = ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(cacheName, DefaultTemplate.DIST_SYNC);
        return this;
    }

    private static void configure(ServerConfigurationBuilder builder, JsonObject server) {
        String uri = server.getString("uri");
        if (uri != null) {
            builder.uri(uri);
        } else {
            builder.host(server.getString("host", "localhost")).port(server.getInteger("port", Integer.valueOf(11222)).intValue());
            String clientIntelligence = server.getString("clientIntelligence");
            if (clientIntelligence != null) {
                builder.clientIntelligence(ClientIntelligence.valueOf((String)clientIntelligence));
            }
            builder.security().authentication().username(Objects.requireNonNull(server.getString("username"), "username is required")).password(Objects.requireNonNull(server.getString("password"), "password is required")).realm(server.getString("realm", "default")).saslMechanism(server.getString("saslMechanism", "DIGEST-MD5"));
            String saslQop = server.getString("saslQop");
            if (saslQop != null) {
                builder.security().authentication().saslQop(new SaslQop[]{SaslQop.valueOf((String)saslQop)});
            }
        }
    }

    public long retryTimeout() {
        return this.options.getLong("retryTimeout", Long.valueOf(5000L));
    }

    public Session createSession(long timeout) {
        return this.createSession(timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        Future.fromCompletionStage((CompletionStage)this.sessions.getAsync((Object)id), (Context)this.vertx.getOrCreateContext()).map(current -> {
            SharedDataSessionImpl session;
            if (current == null) {
                session = null;
            } else {
                session = new SharedDataSessionImpl(this.random);
                session.readFromBuffer(0, Buffer.buffer((byte[])current));
            }
            return session;
        }).onComplete(resultHandler);
    }

    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        Future.fromCompletionStage((CompletionStage)this.sessions.removeAsync((Object)id), (Context)this.vertx.getOrCreateContext()).mapEmpty().onComplete(resultHandler);
    }

    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        Future.fromCompletionStage((CompletionStage)this.sessions.getAsync((Object)session.id()), (Context)this.vertx.getOrCreateContext()).compose(current -> {
            AbstractSession newSession = (AbstractSession)session;
            if (current != null) {
                SharedDataSessionImpl oldSession = new SharedDataSessionImpl(this.random);
                oldSession.readFromBuffer(0, Buffer.buffer((byte[])current));
                if (oldSession.version() != newSession.version()) {
                    return Future.failedFuture((String)"Session version mismatch");
                }
            }
            newSession.incrementVersion();
            return this.writeSession((Session)newSession);
        }).onComplete(resultHandler);
    }

    private Future<Void> writeSession(Session session) {
        Buffer buffer = Buffer.buffer();
        SharedDataSessionImpl sessionImpl = (SharedDataSessionImpl)session;
        sessionImpl.writeToBuffer(buffer);
        CompletableFuture putAsync = this.sessions.putAsync((Object)session.id(), (Object)buffer.getBytes(), 2L * session.timeout(), TimeUnit.MILLISECONDS, session.timeout(), TimeUnit.MILLISECONDS);
        return Future.fromCompletionStage((CompletionStage)putAsync, (Context)this.vertx.getOrCreateContext()).mapEmpty();
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        Future.fromCompletionStage((CompletionStage)this.sessions.clearAsync(), (Context)this.vertx.getOrCreateContext()).onComplete(resultHandler);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        Future.fromCompletionStage((CompletionStage)this.sessions.sizeAsync(), (Context)this.vertx.getOrCreateContext()).map(val -> (int)Math.min(val, Integer.MAX_VALUE)).onComplete(resultHandler);
    }

    public void close() {
        this.remoteCacheManager.close();
    }
}

