/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCChangeClusterStateCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.operation.ChangeClusterStateOperation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;

public class ChangeClusterStateMessageTask
extends AbstractInvocationMessageTask<Integer> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("cluster.changeState");

    public ChangeClusterStateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Integer decodeClientMessage(ClientMessage clientMessage) {
        return MCChangeClusterStateCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCChangeClusterStateCodec.encodeResponse();
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
    }

    @Override
    protected Operation prepareOperation() {
        return new ChangeClusterStateOperation(ClusterState.getById((Integer)this.parameters));
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getMethodName() {
        return "changeClusterState";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

