/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.fetch;

import com.hazelcast.sql.impl.exec.fetch.FetchRow;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.EmptyRowBatch;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import java.util.ArrayList;

public class Fetch {
    private final Expression<?> fetch;
    private final Expression<?> offset;
    private long fetchValue;
    private long offsetValue;
    private long offsetApplied;
    private long fetchApplied;

    public Fetch(Expression<?> fetch, Expression<?> offset) {
        this.fetch = fetch;
        this.offset = offset;
    }

    public void setup(ExpressionEvalContext context) {
        this.fetchValue = Fetch.getFetchValue(context, this.fetch);
        this.offsetValue = Fetch.getOffsetValue(context, this.offset);
    }

    public static long getFetchValue(ExpressionEvalContext context, Expression<?> fetch) {
        return fetch == null ? Long.MAX_VALUE : Fetch.eval(fetch, context);
    }

    public static long getOffsetValue(ExpressionEvalContext context, Expression<?> offset) {
        return offset == null ? 0L : Fetch.eval(offset, context);
    }

    public RowBatch apply(RowBatch batch) {
        int startIndex;
        if (this.fetchApplied == this.fetchValue) {
            return EmptyRowBatch.INSTANCE;
        }
        long toOffset = this.offsetValue - this.offsetApplied;
        if (toOffset >= (long)batch.getRowCount()) {
            this.offsetApplied += (long)batch.getRowCount();
            return EmptyRowBatch.INSTANCE;
        }
        if (toOffset != 0L) {
            this.offsetApplied = this.offsetValue;
            startIndex = (int)toOffset;
        } else {
            startIndex = 0;
        }
        long toFetch = this.fetchValue - this.fetchApplied;
        long canFetch = batch.getRowCount() - startIndex;
        if (toFetch >= canFetch) {
            this.fetchApplied += canFetch;
            if (startIndex == 0) {
                return batch;
            }
            return this.slice(batch, startIndex, (int)canFetch);
        }
        this.fetchApplied += toFetch;
        return this.slice(batch, startIndex, (int)toFetch);
    }

    public boolean isDone() {
        return this.fetchApplied == this.fetchValue;
    }

    private static long eval(Expression<?> expression, ExpressionEvalContext context) {
        assert (expression != null);
        Object val = expression.eval(FetchRow.INSTANCE, context);
        assert (val != null && val instanceof Number);
        long val0 = ((Number)val).longValue();
        assert (val0 >= 0L);
        return val0;
    }

    private RowBatch slice(RowBatch source, int start, int len) {
        ArrayList<Row> rows = new ArrayList<Row>(len);
        for (int i = start; i < start + len; ++i) {
            Row row = source.getRow(i);
            rows.add(row);
        }
        return new ListRowBatch(rows);
    }
}

