/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.config.keys.ClientIdentityFileWatcher;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.ValidateUtils;

public class ClientIdentitiesWatcher
extends AbstractKeyPairProvider
implements KeyPairProvider {
    private final Collection<ClientIdentityProvider> providers;

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(paths, GenericUtils.supplierOf(ValidateUtils.checkNotNull(loader, "No client identity loader")), GenericUtils.supplierOf(ValidateUtils.checkNotNull(provider, "No password provider")), strict);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        this(ClientIdentitiesWatcher.buildProviders(paths, loader, provider, strict));
    }

    public ClientIdentitiesWatcher(Collection<ClientIdentityProvider> providers) {
        this.providers = providers;
    }

    public List<KeyPair> loadKeys() {
        if (GenericUtils.isEmpty(this.providers)) {
            return Collections.emptyList();
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.providers.size());
        for (ClientIdentityProvider p : this.providers) {
            try {
                KeyPair kp = p.getClientIdentity();
                if (kp == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("loadKeys({}) no key loaded", (Object)p);
                    continue;
                }
                keys.add(kp);
            }
            catch (Throwable e) {
                this.log.warn("loadKeys({}) failed ({}) to load key: {}", new Object[]{p, e.getClass().getSimpleName(), e.getMessage()});
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("loadKeys(" + p + ") key load failure details", e);
            }
        }
        return keys;
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        return ClientIdentitiesWatcher.buildProviders(paths, GenericUtils.supplierOf(ValidateUtils.checkNotNull(loader, "No client identity loader")), GenericUtils.supplierOf(ValidateUtils.checkNotNull(provider, "No password provider")), strict);
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        if (GenericUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        ArrayList<ClientIdentityProvider> providers = new ArrayList<ClientIdentityProvider>(paths.size());
        for (Path path : paths) {
            providers.add(new ClientIdentityFileWatcher(path, loader, provider, strict));
        }
        return providers;
    }
}

