/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.util.List;
import org.apache.sshd.client.config.keys.BuiltinClientIdentitiesWatcher;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultClientIdentitiesWatcher
extends BuiltinClientIdentitiesWatcher {
    public DefaultClientIdentitiesWatcher(ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(loader, provider, true);
    }

    public DefaultClientIdentitiesWatcher(ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(true, loader, provider, strict);
    }

    public DefaultClientIdentitiesWatcher(boolean supportedOnly, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(supportedOnly, GenericUtils.supplierOf(ValidateUtils.checkNotNull(loader, "No client identity loader")), GenericUtils.supplierOf(ValidateUtils.checkNotNull(provider, "No password provider")), strict);
    }

    public DefaultClientIdentitiesWatcher(Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider) {
        this(loader, provider, true);
    }

    public DefaultClientIdentitiesWatcher(Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        this(true, loader, provider, strict);
    }

    public DefaultClientIdentitiesWatcher(boolean supportedOnly, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        super(PublicKeyEntry.getDefaultKeysFolderPath(), supportedOnly, loader, provider, strict);
    }

    public static List<Path> getDefaultBuiltinIdentitiesPaths() {
        return DefaultClientIdentitiesWatcher.getDefaultBuiltinIdentitiesPaths(PublicKeyEntry.getDefaultKeysFolderPath());
    }
}

