/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.forward.TcpipForwarderFactory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.RejectAllForwardingFilter;

public class BaseBuilder<T extends AbstractFactoryManager, S extends BaseBuilder<T, S>>
implements ObjectBuilder<T> {
    public static final FileSystemFactory DEFAULT_FILE_SYSTEM_FACTORY = NativeFileSystemFactory.INSTANCE;
    public static final ForwardingFilter DEFAULT_FORWARDING_FILTER = RejectAllForwardingFilter.INSTANCE;
    public static final TcpipForwarderFactory DEFAULT_FORWARDER_FACTORY = DefaultTcpipForwarderFactory.INSTANCE;
    public static final List<BuiltinCiphers> DEFAULT_CIPHERS_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.arcfour256, BuiltinCiphers.arcfour128, BuiltinCiphers.aes128cbc, BuiltinCiphers.tripledescbc, BuiltinCiphers.blowfishcbc, BuiltinCiphers.aes192cbc, BuiltinCiphers.aes256cbc));
    public static final List<BuiltinDHFactories> DEFAULT_KEX_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinDHFactories.ecdhp521, BuiltinDHFactories.ecdhp384, BuiltinDHFactories.ecdhp256, BuiltinDHFactories.dhgex256, BuiltinDHFactories.dhgex, BuiltinDHFactories.dhg14, BuiltinDHFactories.dhg1));
    public static final List<BuiltinMacs> DEFAULT_MAC_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinMacs.hmacmd5, BuiltinMacs.hmacsha1, BuiltinMacs.hmacsha256, BuiltinMacs.hmacsha512, BuiltinMacs.hmacsha196, BuiltinMacs.hmacmd596));
    public static final List<BuiltinSignatures> DEFAULT_SIGNATURE_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.rsa, BuiltinSignatures.dsa));
    protected Factory<T> factory;
    protected List<NamedFactory<KeyExchange>> keyExchangeFactories;
    protected List<NamedFactory<Cipher>> cipherFactories;
    protected List<NamedFactory<Compression>> compressionFactories;
    protected List<NamedFactory<Mac>> macFactories;
    protected List<NamedFactory<Signature>> signatureFactories;
    protected Factory<Random> randomFactory;
    protected List<NamedFactory<Channel>> channelFactories;
    protected FileSystemFactory fileSystemFactory;
    protected TcpipForwarderFactory tcpipForwarderFactory;
    protected List<RequestHandler<ConnectionService>> globalRequestHandlers;
    protected ForwardingFilter forwardingFilter;

    protected S fillWithDefaultValues() {
        if (this.signatureFactories == null) {
            this.signatureFactories = BaseBuilder.setUpDefaultSignatures(false);
        }
        if (this.randomFactory == null) {
            this.randomFactory = new SingletonRandomFactory(SecurityUtils.getRandomFactory());
        }
        if (this.cipherFactories == null) {
            this.cipherFactories = BaseBuilder.setUpDefaultCiphers(false);
        }
        if (this.macFactories == null) {
            this.macFactories = BaseBuilder.setUpDefaultMacs(false);
        }
        if (this.fileSystemFactory == null) {
            this.fileSystemFactory = DEFAULT_FILE_SYSTEM_FACTORY;
        }
        if (this.forwardingFilter == null) {
            this.forwardingFilter = DEFAULT_FORWARDING_FILTER;
        }
        if (this.tcpipForwarderFactory == null) {
            this.tcpipForwarderFactory = DEFAULT_FORWARDER_FACTORY;
        }
        return this.me();
    }

    public S keyExchangeFactories(List<NamedFactory<KeyExchange>> keyExchangeFactories) {
        this.keyExchangeFactories = keyExchangeFactories;
        return this.me();
    }

    public S signatureFactories(List<NamedFactory<Signature>> signatureFactories) {
        this.signatureFactories = signatureFactories;
        return this.me();
    }

    public S randomFactory(Factory<Random> randomFactory) {
        this.randomFactory = randomFactory;
        return this.me();
    }

    public S cipherFactories(List<NamedFactory<Cipher>> cipherFactories) {
        this.cipherFactories = cipherFactories;
        return this.me();
    }

    public S compressionFactories(List<NamedFactory<Compression>> compressionFactories) {
        this.compressionFactories = compressionFactories;
        return this.me();
    }

    public S macFactories(List<NamedFactory<Mac>> macFactories) {
        this.macFactories = macFactories;
        return this.me();
    }

    public S channelFactories(List<NamedFactory<Channel>> channelFactories) {
        this.channelFactories = channelFactories;
        return this.me();
    }

    public S fileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
        return this.me();
    }

    public S forwardingFilter(ForwardingFilter filter) {
        this.forwardingFilter = filter;
        return this.me();
    }

    public S tcpipForwarderFactory(TcpipForwarderFactory tcpipForwarderFactory) {
        this.tcpipForwarderFactory = tcpipForwarderFactory;
        return this.me();
    }

    public S globalRequestHandlers(List<RequestHandler<ConnectionService>> globalRequestHandlers) {
        this.globalRequestHandlers = globalRequestHandlers;
        return this.me();
    }

    public S factory(Factory<T> factory) {
        this.factory = factory;
        return this.me();
    }

    public T build(boolean isFillWithDefaultValues) {
        if (isFillWithDefaultValues) {
            this.fillWithDefaultValues();
        }
        AbstractFactoryManager ssh = (AbstractFactoryManager)this.factory.create();
        ssh.setKeyExchangeFactories(this.keyExchangeFactories);
        ssh.setSignatureFactories(this.signatureFactories);
        ssh.setRandomFactory(this.randomFactory);
        ssh.setCipherFactories(this.cipherFactories);
        ssh.setCompressionFactories(this.compressionFactories);
        ssh.setMacFactories(this.macFactories);
        ssh.setChannelFactories(this.channelFactories);
        ssh.setFileSystemFactory(this.fileSystemFactory);
        ssh.setTcpipForwardingFilter(this.forwardingFilter);
        ssh.setTcpipForwarderFactory(this.tcpipForwarderFactory);
        ssh.setGlobalRequestHandlers(this.globalRequestHandlers);
        return (T)ssh;
    }

    @Override
    public T build() {
        return this.build(true);
    }

    protected S me() {
        return (S)this;
    }

    public static List<NamedFactory<Cipher>> setUpDefaultCiphers(boolean ignoreUnsupported) {
        return NamedFactory.Utils.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_CIPHERS_PREFERENCE);
    }

    public static List<NamedFactory<Mac>> setUpDefaultMacs(boolean ignoreUnsupported) {
        return NamedFactory.Utils.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_MAC_PREFERENCE);
    }

    public static List<NamedFactory<Signature>> setUpDefaultSignatures(boolean ignoreUnsupported) {
        return NamedFactory.Utils.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_SIGNATURE_PREFERENCE);
    }
}

