/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class EventListenerUtils {
    private EventListenerUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T extends EventListener> T proxyWrapper(Class<T> listenerType, Iterable<? extends T> listeners) {
        return EventListenerUtils.proxyWrapper(listenerType, listenerType.getClassLoader(), listeners);
    }

    public static <T extends EventListener> T proxyWrapper(Class<T> listenerType, ClassLoader loader, final Iterable<? extends T> listeners) {
        ValidateUtils.checkNotNull(listenerType, "No listener type specified");
        ValidateUtils.checkTrue(listenerType.isInterface(), "Target proxy is not an interface: %s", (Object)listenerType.getSimpleName());
        ValidateUtils.checkNotNull(listeners, "No listeners container provided");
        Object wrapper = Proxy.newProxyInstance(loader, new Class[]{listenerType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Throwable err = null;
                for (EventListener l : listeners) {
                    try {
                        method.invoke((Object)l, args);
                    }
                    catch (Throwable t) {
                        Throwable e = GenericUtils.peelException(t);
                        err = GenericUtils.accumulateException(err, e);
                    }
                }
                if (err != null) {
                    throw err;
                }
                return null;
            }
        });
        return (T)((EventListener)listenerType.cast(wrapper));
    }
}

