/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.util.Predicate;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.Transformer;
import org.apache.sshd.common.util.ValidateUtils;

public final class GenericUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Object NULL = new Object();
    public static final Comparator<String> CASE_SENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            return s1.compareTo(s2);
        }
    };
    public static final String QUOTES = "\"'";
    private static final Comparator<Comparable> NATURAL_ORDER_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable c1, Comparable c2) {
            return c1.compareTo(c2);
        }
    };
    private static final Factory CASE_INSENSITIVE_MAP_FACTORY = new Factory(){

        public Object create() {
            return new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
    };

    private GenericUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static int safeCompare(String s1, String s2, boolean caseSensitive) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        if (caseSensitive) {
            return s1.compareTo(s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return GenericUtils.length(cs) <= 0;
    }

    public static String[] split(String s, char ch) {
        String v;
        if (GenericUtils.isEmpty(s)) {
            return EMPTY_STRING_ARRAY;
        }
        int lastPos = 0;
        int curPos = s.indexOf(ch);
        if (curPos < 0) {
            return new String[]{s};
        }
        LinkedList<String> values = new LinkedList<String>();
        do {
            v = s.substring(lastPos, curPos);
            values.add(v);
            lastPos = curPos + 1;
        } while (lastPos < s.length() && (curPos = s.indexOf(ch, lastPos)) >= lastPos && curPos < s.length());
        if (lastPos < s.length()) {
            v = s.substring(lastPos);
            values.add(v);
        }
        return values.toArray(new String[values.size()]);
    }

    public static <T> String join(T[] values, char ch) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), ch);
    }

    public static String join(Iterable<?> iter, char ch) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), ch);
    }

    public static String join(Iterator<?> iter, char ch) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(ch);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static <T> String join(T[] values, CharSequence sep) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), sep);
    }

    public static String join(Iterable<?> iter, CharSequence sep) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), sep);
    }

    public static String join(Iterator<?> iter, CharSequence sep) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    @SafeVarargs
    public static <T> int length(T ... a) {
        return a == null ? 0 : a.length;
    }

    public static <T> boolean isEmpty(Iterable<? extends T> iter) {
        if (iter == null) {
            return true;
        }
        if (iter instanceof Collection) {
            return GenericUtils.isEmpty((Collection)iter);
        }
        return GenericUtils.isEmpty(iter.iterator());
    }

    public static <T> boolean isEmpty(Iterator<? extends T> iter) {
        return iter == null || !iter.hasNext();
    }

    @SafeVarargs
    public static <T> boolean isEmpty(T ... a) {
        return GenericUtils.length(a) <= 0;
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> of(E ... values) {
        return GenericUtils.of(GenericUtils.isEmpty(values) ? Collections.emptySet() : Arrays.asList(values));
    }

    public static <E extends Enum<E>> Set<E> of(Collection<? extends E> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptySet();
        }
        EnumSet<Enum> result = null;
        for (Enum v : values) {
            if (result == null) {
                result = EnumSet.of(v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... values) {
        int len = GenericUtils.length(values);
        if (len <= 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(values);
    }

    public static <V extends Comparable<V>> Comparator<V> naturalComparator() {
        return NATURAL_ORDER_COMPARATOR;
    }

    public static <V extends Comparable<V>> SortedSet<V> asSortedSet(Collection<? extends V> values) {
        return GenericUtils.asSortedSet(GenericUtils.naturalComparator(), values);
    }

    @SafeVarargs
    public static <V> SortedSet<V> asSortedSet(Comparator<? super V> comp, V ... values) {
        return GenericUtils.asSortedSet(comp, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <V> SortedSet<V> asSortedSet(Comparator<? super V> comp, Collection<? extends V> values) {
        TreeSet<V> set = new TreeSet<V>(ValidateUtils.checkNotNull(comp, "No comparator"));
        if (GenericUtils.size(values) > 0) {
            set.addAll(values);
        }
        return set;
    }

    public static <V> Factory<SortedMap<String, V>> caseInsensitiveMap() {
        return CASE_INSENSITIVE_MAP_FACTORY;
    }

    public static <K, V> Map<V, K> flipMap(Map<? extends K, ? extends V> map, Factory<? extends Map<V, K>> mapCreator, boolean allowDuplicates) {
        if (GenericUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        Map<K, V> result = ValidateUtils.checkNotNull(mapCreator.create(), "No map created");
        for (Map.Entry<K, V> ee : map.entrySet()) {
            K key = ee.getKey();
            V value = ee.getValue();
            K prev = result.put(value, key);
            if (prev == null || allowDuplicates) continue;
            ValidateUtils.throwIllegalArgumentException("Multiple values for key=%s: current=%s, previous=%s", value, key, prev);
        }
        return result;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapValues(Transformer<? super V, ? extends K> keyMapper, Factory<? extends Map<K, V>> mapCreator, V ... values) {
        return GenericUtils.mapValues(keyMapper, mapCreator, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <K, V> Map<K, V> mapValues(Transformer<? super V, ? extends K> keyMapper, Factory<? extends Map<K, V>> mapCreator, Collection<? extends V> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        Map<K, V> map = mapCreator.create();
        for (V v : values) {
            K k = keyMapper.transform(v);
            if (k == null) continue;
            map.put(k, v);
        }
        return map;
    }

    @SafeVarargs
    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, T ... values) {
        return GenericUtils.selectMatchingMembers(acceptor, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, Collection<? extends T> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<T> matches = new ArrayList<T>(values.size());
        for (T v : values) {
            if (!acceptor.evaluate(v)) continue;
            matches.add(v);
        }
        return matches;
    }

    public static CharSequence stripQuotes(CharSequence s) {
        if (GenericUtils.isEmpty(s)) {
            return s;
        }
        for (int index = 0; index < QUOTES.length(); ++index) {
            char delim = QUOTES.charAt(index);
            CharSequence v = GenericUtils.stripDelimiters(s, delim);
            if (v == s) continue;
            return v;
        }
        return s;
    }

    public static CharSequence stripDelimiters(CharSequence s, char delim) {
        if (GenericUtils.isEmpty(s) || s.length() < 2) {
            return s;
        }
        int lastPos = s.length() - 1;
        if (s.charAt(0) != delim || s.charAt(lastPos) != delim) {
            return s;
        }
        return s.subSequence(1, lastPos);
    }

    public static Throwable peelException(Throwable t) {
        Exception target;
        if (t == null) {
            return t;
        }
        if (t instanceof UndeclaredThrowableException) {
            Throwable wrapped = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
            if (wrapped != null) {
                return GenericUtils.peelException(wrapped);
            }
            wrapped = t.getCause();
            if (wrapped != t) {
                return GenericUtils.peelException(wrapped);
            }
        } else if (t instanceof InvocationTargetException) {
            Throwable target2 = ((InvocationTargetException)t).getTargetException();
            if (target2 != null) {
                return GenericUtils.peelException(target2);
            }
        } else if (t instanceof ReflectionException) {
            Exception target3 = ((ReflectionException)t).getTargetException();
            if (target3 != null) {
                return GenericUtils.peelException(target3);
            }
        } else if (t instanceof MBeanException && (target = ((MBeanException)t).getTargetException()) != null) {
            return GenericUtils.peelException(target);
        }
        return t;
    }

    public static Throwable resolveExceptionCause(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable c = t.getCause();
        if (c == null) {
            return t;
        }
        return c;
    }

    public static <T extends Throwable> T accumulateException(T current, T extra) {
        if (current == null) {
            return extra;
        }
        if (extra == null || extra == current) {
            return current;
        }
        current.addSuppressed(extra);
        return current;
    }

    public static <T> Supplier<T> supplierOf(final T value) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }

            public String toString() {
                return Supplier.class.getSimpleName() + "[" + value + "]";
            }
        };
    }

    public static <T> Iterator<T> iteratorOf(Iterable<T> iterable) {
        return GenericUtils.iteratorOf(iterable == null ? null : iterable.iterator());
    }

    public static <T> Iterator<T> iteratorOf(Iterator<T> iter) {
        return iter == null ? Collections.emptyIterator() : iter;
    }

    public static <T> Iterable<T> multiIterableSuppliers(final Iterable<? extends Supplier<? extends Iterable<? extends T>>> providers) {
        return providers == null ? Collections.emptyList() : new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<? extends Supplier<? extends Iterable<? extends T>>> iter;
                    private Iterator<? extends T> current;
                    {
                        this.iter = GenericUtils.iteratorOf(providers);
                        this.current = this.nextIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null;
                    }

                    @Override
                    public T next() {
                        if (this.current == null) {
                            throw new NoSuchElementException("No more elements");
                        }
                        Object value = this.current.next();
                        if (!this.current.hasNext()) {
                            this.current = this.nextIterator();
                        }
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    private Iterator<? extends T> nextIterator() {
                        while (this.iter.hasNext()) {
                            Supplier supplier = this.iter.next();
                            Iterator values = GenericUtils.iteratorOf(supplier == null ? null : supplier.get());
                            if (!values.hasNext()) continue;
                            return values;
                        }
                        return null;
                    }
                };
            }
        };
    }
}

