/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.File;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";

    private SelectorUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            return true;
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        String altStr = str.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(pattern, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(pattern, altStr, "/", isCaseSensitive);
    }

    private static boolean matchAntPathPatternStart(String pattern, String str, String separator, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern.startsWith(separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern, separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs.get(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str, true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(REGEX_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
            return str.matches(pattern);
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(pattern, str, isCaseSensitive);
    }

    private static boolean matchAntPathPattern(String pattern, String str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        List<String> patDirs = SelectorUtils.tokenizePath(pattern, File.separator);
        List<String> strDirs = SelectorUtils.tokenizePath(str, File.separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs.get(strIdxStart), isCaseSensitive)) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs.get(i).equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            patDirs = null;
            strDirs = null;
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs.get(patIdxEnd)).equals("**")) {
            if (!SelectorUtils.match(patDir, strDirs.get(strIdxEnd), isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs.get(i).equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!patDirs.get(i).equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr;
                    String subPat = patDirs.get(patIdxStart + j + 1);
                    if (!SelectorUtils.match(subPat, subStr = strDirs.get(strIdxStart + i + j), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patDirs.get(i).equals("**")) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || SelectorUtils.equals(ch2, strArr[i], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart + i3 + j], isCaseSensitive)) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    public static List<String> tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static List<String> tokenizePath(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static String normalizePath(String path, String separator) {
        if (GenericUtils.isEmpty(path)) {
            return path;
        }
        boolean startsWithSeparator = path.startsWith(separator);
        List<String> tokens = SelectorUtils.tokenizePath(path, separator);
        int removedDots = 0;
        for (int i = tokens.size() - 1; i >= 0; --i) {
            String t = tokens.get(i);
            if (GenericUtils.isEmpty(t)) {
                tokens.remove(i);
                continue;
            }
            if (t.equals(".")) {
                tokens.remove(i);
                ++removedDots;
                continue;
            }
            if (!t.equals("..")) continue;
            tokens.remove(i);
            ++removedDots;
            if (i < 1) continue;
            tokens.remove(--i);
            ++removedDots;
        }
        if (GenericUtils.isEmpty(tokens)) {
            if (removedDots > 0) {
                return "";
            }
            return separator;
        }
        StringBuilder buffer = new StringBuilder(path.length());
        for (int index = 0; index < tokens.size(); ++index) {
            String token = tokens.get(index);
            if (index == 0) {
                if (startsWithSeparator) {
                    buffer.append(separator);
                } else if (OsUtils.isWin32() && SelectorUtils.isWindowsDriveSpecified(token)) {
                    buffer.append(separator);
                }
            } else {
                buffer.append(separator);
            }
            buffer.append(token);
            if (tokens.size() != 1 || !OsUtils.isWin32() || !SelectorUtils.isWindowsDriveSpecified(token)) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String translateToLocalFileSystemPath(String path, char pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToLocalFileSystemPath(path, pathSeparator, ValidateUtils.checkNotNull(fs, "No target file system").getSeparator());
    }

    public static String translateToLocalFileSystemPath(String path, char pathSeparator, String fsSeparator) {
        String slashified = SelectorUtils.applySlashifyRules(path, pathSeparator);
        String localPath = SelectorUtils.translateToLocalPath(slashified);
        return SelectorUtils.translateToFileSystemPath(localPath, File.separator, fsSeparator);
    }

    public static String applySlashifyRules(String path, char sepChar) {
        if (GenericUtils.isEmpty(path)) {
            return path;
        }
        int curPos = path.indexOf(sepChar);
        if (curPos < 0) {
            return path;
        }
        int lastPos = 0;
        StringBuilder sb = null;
        while (curPos < path.length()) {
            int nextPos;
            for (nextPos = ++curPos; nextPos < path.length() && path.charAt(nextPos) == sepChar; ++nextPos) {
            }
            int seqLen = nextPos - curPos;
            if (seqLen > 0) {
                if (sb == null) {
                    sb = new StringBuilder(path.length() - seqLen);
                }
                if (lastPos < curPos) {
                    String clrText = path.substring(lastPos, curPos);
                    sb.append(clrText);
                }
                lastPos = nextPos;
            }
            if (nextPos < path.length() && (curPos = path.indexOf(sepChar, nextPos)) >= nextPos) continue;
            break;
        }
        if (sb != null) {
            if (lastPos < path.length()) {
                String clrText = path.substring(lastPos);
                sb.append(clrText);
            }
            path = sb.toString();
        }
        if (path.length() > 1 && path.charAt(path.length() - 1) == sepChar) {
            return path + ".";
        }
        return path;
    }

    public static String translateToLocalPath(String path) {
        if (GenericUtils.isEmpty(path) || File.separatorChar == '/') {
            return path;
        }
        String localPath = path.replace('/', File.separatorChar);
        if (localPath.charAt(0) == File.separatorChar && SelectorUtils.isWindowsDriveSpecified(localPath, 1, localPath.length() - 1)) {
            localPath = localPath.substring(1);
        }
        if (!SelectorUtils.isWindowsDriveSpecified(localPath)) {
            return localPath;
        }
        if (localPath.length() == 2) {
            return localPath + File.separator;
        }
        if (localPath.charAt(2) != File.separatorChar) {
            return localPath.substring(0, 2) + File.separator + localPath.substring(2);
        }
        return localPath;
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs) {
        return SelectorUtils.isWindowsDriveSpecified(cs, 0, GenericUtils.length(cs));
    }

    public static boolean isWindowsDriveSpecified(CharSequence cs, int offset, int len) {
        if (len < 2 || cs.charAt(offset + 1) != ':') {
            return false;
        }
        char drive = cs.charAt(offset);
        return drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z';
    }

    public static String translateToFileSystemPath(String path, String pathSeparator, FileSystem fs) {
        return SelectorUtils.translateToFileSystemPath(path, pathSeparator, ValidateUtils.checkNotNull(fs, "No target file system").getSeparator());
    }

    public static String translateToFileSystemPath(String path, String pathSeparator, String fsSeparator) {
        ValidateUtils.checkNotNullAndNotEmpty(pathSeparator, "Missing path separator");
        ValidateUtils.checkNotNullAndNotEmpty(fsSeparator, "Missing file-system separator");
        if (GenericUtils.isEmpty(path) || Objects.equals(pathSeparator, fsSeparator)) {
            return path;
        }
        if (path.indexOf(fsSeparator) >= 0) {
            ValidateUtils.throwIllegalArgumentException("File system replacement may yield ambiguous result for %s with separator=%s", path, fsSeparator);
        }
        if (pathSeparator.length() == 1 && fsSeparator.length() == 1) {
            return path.replace(pathSeparator.charAt(0), fsSeparator.charAt(0));
        }
        return path.replace(pathSeparator, fsSeparator);
    }

    public static boolean isOutOfDate(File src, File target, int granularity) {
        if (!src.exists()) {
            return false;
        }
        if (!target.exists()) {
            return true;
        }
        return src.lastModified() - (long)granularity > target.lastModified();
    }

    public static String removeWhitespace(String input) {
        StringBuffer result = new StringBuffer();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }
}

