/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class FuturesCloseable<T extends SshFuture>
extends SimpleCloseable {
    private final Iterable<? extends SshFuture<T>> futures;

    public FuturesCloseable(Object lock, Iterable<? extends SshFuture<T>> futures) {
        super(lock);
        this.futures = futures == null ? Collections.emptyList() : futures;
    }

    @Override
    protected void doClose(final boolean immediately) {
        if (immediately) {
            for (SshFuture<T> f : this.futures) {
                if (!(f instanceof DefaultSshFuture)) continue;
                ((DefaultSshFuture)f).setValue(new SshException("Closed"));
            }
            this.future.setClosed();
        } else {
            final AtomicInteger count = new AtomicInteger(1);
            SshFutureListener listener = new SshFutureListener<T>(){

                @Override
                public void operationComplete(T f) {
                    int pendingCount = count.decrementAndGet();
                    if (FuturesCloseable.this.log.isTraceEnabled()) {
                        FuturesCloseable.this.log.trace("doClose(" + immediately + ") complete pending: " + pendingCount);
                    }
                    if (pendingCount == 0) {
                        FuturesCloseable.this.future.setClosed();
                    }
                }
            };
            for (SshFuture<T> f : this.futures) {
                if (f == null) continue;
                int pendingCount = count.incrementAndGet();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("doClose(" + immediately + ") future pending: " + pendingCount);
                }
                f.addListener(listener);
            }
            listener.operationComplete(null);
        }
    }
}

