/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.util.GenericUtils;

public enum Signal {
    HUP(1),
    INT(2),
    QUIT(3),
    ILL(4),
    TRAP(5),
    IOT(6),
    BUS(7),
    FPE(8),
    KILL(9),
    USR1(10),
    SEGV(11),
    USR2(12),
    PIPE(13),
    ALRM(14),
    TERM(15),
    STKFLT(16),
    CHLD(17),
    CONT(18),
    STOP(19),
    TSTP(20),
    TTIN(21),
    TTOU(22),
    URG(23),
    XCPU(24),
    XFSZ(25),
    VTALRM(26),
    PROF(27),
    WINCH(28),
    IO(29),
    PWR(30);

    public static final Set<Signal> SIGNALS;
    public static final Map<String, Signal> NAME_LOOKUP_TABLE;
    public static final Map<Integer, Signal> NUMERIC_LOOKUP_TABLE;
    private final int numeric;

    private Signal(int numeric) {
        this.numeric = numeric;
    }

    public int getNumeric() {
        return this.numeric;
    }

    public static Signal get(String name) {
        return GenericUtils.isEmpty(name) ? null : NAME_LOOKUP_TABLE.get(name);
    }

    public static Signal get(int num) {
        return NUMERIC_LOOKUP_TABLE.get(num);
    }

    static {
        SIGNALS = Collections.unmodifiableSet(EnumSet.allOf(Signal.class));
        NAME_LOOKUP_TABLE = Collections.unmodifiableMap(new TreeMap<String, Signal>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;
            {
                for (Signal s : SIGNALS) {
                    this.put(s.name(), s);
                }
            }
        });
        NUMERIC_LOOKUP_TABLE = Collections.unmodifiableMap(new HashMap<Integer, Signal>(SIGNALS.size()){
            private static final long serialVersionUID = 1L;
            {
                for (Signal s : SIGNALS) {
                    this.put(s.getNumeric(), s);
                }
            }
        });
    }
}

