/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.subsystem.sftp.AbstractSftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystemFactory
extends AbstractSftpEventListenerManager
implements SubsystemFactory,
ExecutorServiceConfigurer,
SftpEventListenerManager {
    public static final String NAME = "sftp";
    public static final UnsupportedAttributePolicy DEFAULT_POLICY = UnsupportedAttributePolicy.Warn;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private UnsupportedAttributePolicy policy = DEFAULT_POLICY;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executors;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executors = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdownOnExit) {
        this.shutdownExecutor = shutdownOnExit;
    }

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.policy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
        this.policy = ValidateUtils.checkNotNull(p, "No policy");
    }

    @Override
    public Command create() {
        SftpSubsystem subsystem = new SftpSubsystem(this.getExecutorService(), this.isShutdownOnExit(), this.getUnsupportedAttributePolicy());
        Collection<SftpEventListener> listeners = this.getRegisteredListeners();
        if (GenericUtils.size(listeners) > 0) {
            for (SftpEventListener l : listeners) {
                subsystem.addSftpEventListener(l);
            }
        }
        return subsystem;
    }

    public static class Builder
    extends AbstractSftpEventListenerManager
    implements ObjectBuilder<SftpSubsystemFactory> {
        private ExecutorService executors;
        private boolean shutdownExecutor;
        private UnsupportedAttributePolicy policy = DEFAULT_POLICY;

        public Builder withExecutorService(ExecutorService service) {
            this.executors = service;
            return this;
        }

        public Builder withShutdownOnExit(boolean shutdown) {
            this.shutdownExecutor = shutdown;
            return this;
        }

        public Builder withUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
            this.policy = ValidateUtils.checkNotNull(p, "No policy");
            return this;
        }

        @Override
        public SftpSubsystemFactory build() {
            SftpSubsystemFactory factory = new SftpSubsystemFactory();
            factory.setExecutorService(this.executors);
            factory.setShutdownOnExit(this.shutdownExecutor);
            factory.setUnsupportedAttributePolicy(this.policy);
            Collection<SftpEventListener> listeners = this.getRegisteredListeners();
            if (GenericUtils.size(listeners) > 0) {
                for (SftpEventListener l : listeners) {
                    factory.addSftpEventListener(l);
                }
            }
            return factory;
        }
    }
}

