/*
 * Decompiled with CFR 0.152.
 */
package examples.screencast;

import io.termd.core.tty.TtyConnection;
import io.termd.core.util.Vector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;

public class Screencaster {
    private final Robot robot;
    private final TtyConnection conn;
    private boolean interrupted;

    public Screencaster(Robot robot, TtyConnection conn) {
        this.robot = robot;
        this.conn = conn;
        conn.setEventHandler((event, key) -> {
            this.interrupted = true;
        });
    }

    public void handle() {
        if (this.conn.size() != null) {
            this.broadcast();
        } else {
            this.conn.setSizeHandler(size -> this.broadcast());
        }
    }

    private void broadcast() {
        if (this.interrupted) {
            this.conn.close();
            return;
        }
        BufferedImage capture = this.robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        Vector size = this.conn.size();
        Image temp = capture.getScaledInstance(size.x(), size.y(), 4);
        BufferedImage scaled = new BufferedImage(size.x(), size.y(), 2);
        Graphics2D g2d = scaled.createGraphics();
        g2d.drawImage(temp, 0, 0, null);
        g2d.dispose();
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < size.y(); ++y) {
            sb.append("\u001b[").append(y + 1).append(";1H");
            for (int x = 0; x < size.x(); ++x) {
                int b;
                int g;
                Color pixel = new Color(scaled.getRGB(x, y));
                int r = pixel.getRed();
                double grey = (double)(r + (g = pixel.getGreen()) + (b = pixel.getBlue())) / 3.0;
                if (grey < 51.0) {
                    sb.append('\u2588');
                    continue;
                }
                if (grey < 102.0) {
                    sb.append('\u2593');
                    continue;
                }
                if (grey < 153.0) {
                    sb.append('\u2592');
                    continue;
                }
                if (grey < 204.0) {
                    sb.append('\u2591');
                    continue;
                }
                sb.append(' ');
            }
        }
        this.conn.write(sb.toString());
        this.conn.schedule(this::broadcast, 100L, TimeUnit.MILLISECONDS);
    }
}

