/*
 * Decompiled with CFR 0.152.
 */
package examples.shell;

import io.termd.core.readline.Function;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.Readline;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.util.Helper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Shell
implements Consumer<TtyConnection> {
    private static final Pattern splitter = Pattern.compile("\\w+");

    @Override
    public void accept(TtyConnection conn) {
        InputStream inputrc = Keymap.class.getResourceAsStream("inputrc");
        Keymap keymap = new Keymap(inputrc);
        Readline readline = new Readline(keymap);
        for (Function function : Helper.loadServices(Thread.currentThread().getContextClassLoader(), Function.class)) {
            readline.addFunction(function);
        }
        conn.write("Welcome to Term.d shell example\n\n");
        this.read(conn, readline);
    }

    public void read(TtyConnection conn, Readline readline) {
        readline.readline(conn, "% ", line -> {
            if (line == null) {
                conn.write("logout\n").close();
                return;
            }
            Matcher matcher = splitter.matcher((CharSequence)line);
            if (matcher.find()) {
                String cmd = matcher.group();
                ArrayList<String> args = new ArrayList<String>();
                while (matcher.find()) {
                    args.add(matcher.group());
                }
                try {
                    new Task(conn, readline, Command.valueOf(cmd), args).start();
                    return;
                }
                catch (IllegalArgumentException e) {
                    conn.write(cmd + ": command not found\n");
                }
            }
            this.read(conn, readline);
        });
    }

    static enum Command {
        sleep{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                if (args.isEmpty()) {
                    conn.write("usage: sleep seconds\n");
                    return;
                }
                int time = -1;
                try {
                    time = Integer.parseInt(args.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (time > 0) {
                    Thread.sleep(time * 1000);
                }
            }
        }
        ,
        echo{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                for (int i = 0; i < args.size(); ++i) {
                    if (i > 0) {
                        conn.write(" ");
                    }
                    conn.write(args.get(i));
                }
                conn.write("\n");
            }
        }
        ,
        window{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                conn.write("Current window size " + conn.size() + ", try resize it\n");
                conn.setSizeHandler(size -> conn.write("Window resized " + size + "\n"));
                try {
                    new CountDownLatch(1).await();
                }
                finally {
                    conn.setSizeHandler(null);
                }
            }
        }
        ,
        help{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                StringBuilder msg = new StringBuilder("Demo term, try commands: ");
                Command[] commands = Command.values();
                for (int i = 0; i < commands.length; ++i) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(" ").append(commands[i].name());
                }
                msg.append("...\n");
                conn.write(msg.toString());
            }
        }
        ,
        keyscan{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                conn.setStdinHandler(keys -> {
                    for (int key : keys) {
                        conn.write(key + " pressed\n");
                    }
                });
                try {
                    new CountDownLatch(1).await();
                }
                finally {
                    conn.setStdinHandler(null);
                }
            }
        }
        ,
        top{

            @Override
            public void execute(TtyConnection conn, List<String> args) throws Exception {
                while (true) {
                    StringBuilder buf = new StringBuilder();
                    Formatter formatter = new Formatter(buf);
                    ArrayList<Thread> threads = new ArrayList<Thread>(Thread.getAllStackTraces().keySet());
                    for (int i = 1; i <= conn.size().y(); ++i) {
                        buf.append("\u001b[").append(i).append(";1H\u001b[K");
                        String format = "  %1$-5s %2$-10s %3$-50s %4$s";
                        if (i == 1) {
                            formatter.format(format, "ID", "STATE", "NAME", "GROUP");
                            continue;
                        }
                        int index = i - 2;
                        if (index >= threads.size()) continue;
                        Thread thread = (Thread)threads.get(index);
                        formatter.format(format, thread.getId(), thread.getState().name(), thread.getName(), thread.getThreadGroup().getName());
                    }
                    conn.write(buf.toString());
                    Thread.sleep(1000L);
                }
            }
        };


        abstract void execute(TtyConnection var1, List<String> var2) throws Exception;
    }

    class Task
    extends Thread
    implements BiConsumer<TtyEvent, Integer> {
        final TtyConnection conn;
        final Readline readline;
        final Command command;
        final List<String> args;
        volatile boolean running;

        public Task(TtyConnection conn, Readline readline, Command command, List<String> args) {
            this.conn = conn;
            this.readline = readline;
            this.command = command;
            this.args = args;
        }

        @Override
        public void accept(TtyEvent event, Integer cp) {
            switch (event) {
                case INTR: {
                    if (!this.running) break;
                    this.interrupt();
                }
            }
        }

        @Override
        public void run() {
            this.conn.setEventHandler(this);
            this.running = true;
            try {
                this.command.execute(this.conn, this.args);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.running = false;
                this.conn.setEventHandler(null);
                Shell.this.read(this.conn, this.readline);
            }
        }
    }
}

