/*
 * Decompiled with CFR 0.152.
 */
package examples.snake;

import io.termd.core.tty.TtyConnection;
import io.termd.core.util.Vector;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class SnakeGame
implements Consumer<TtyConnection> {
    @Override
    public void accept(TtyConnection conn) {
        if (conn.size() != null) {
            new Game(conn).execute();
        } else {
            conn.setSizeHandler(size -> new Game(conn).execute());
        }
    }

    class Game {
        final TtyConnection conn;
        GameState game;
        boolean interrupted;

        public Game(TtyConnection conn) {
            this.conn = conn;
            conn.setSizeHandler(this::reset);
            conn.setEventHandler((event, ch) -> {
                switch (event) {
                    case INTR: {
                        this.interrupted = true;
                        conn.close();
                    }
                }
            });
            conn.setStdinHandler(keys -> {
                if (((int[])keys).length == 3 && keys[0] == 27 && keys[1] == 91) {
                    switch (keys[2]) {
                        case 65: {
                            this.game.direction = Direction.UP;
                            break;
                        }
                        case 66: {
                            this.game.direction = Direction.DOWN;
                            break;
                        }
                        case 67: {
                            this.game.direction = Direction.RIGHT;
                            break;
                        }
                        case 68: {
                            this.game.direction = Direction.LEFT;
                        }
                    }
                }
            });
            this.reset(conn.size());
        }

        void execute() {
            if (this.interrupted) {
                return;
            }
            GameState game = this.game;
            StringBuilder buf = new StringBuilder();
            for (int y = 0; y < game.height; ++y) {
                buf.append("\u001b[").append(y + 1).append(";1H\u001b[K");
            }
            for (Vector tile : game.tiles) {
                buf.append("\u001b[").append(tile.y() + 1).append(";").append(tile.x() + 1).append("H").append("X");
            }
            for (Vector tile : game.snake) {
                buf.append("\u001b[").append(tile.y() + 1).append(";").append(tile.x() + 1).append("H").append('0');
            }
            buf.append("\u001b[").append(game.height).append(";").append(game.width).append("H\u001b[K");
            this.conn.write(buf.toString());
            try {
                game.update();
            }
            catch (Exception e) {
                this.conn.write("YOU LOST");
                this.conn.close();
                return;
            }
            this.conn.schedule(this::execute, 500L, TimeUnit.MILLISECONDS);
        }

        private void reset(Vector size) {
            this.game = new GameState(size.x(), size.y(), size.x() * size.y() / 10);
        }
    }

    class GameState {
        final int width;
        final int height;
        HashSet<Vector> tiles;
        LinkedList<Vector> snake = new LinkedList();
        Direction direction;

        GameState(int width, int height, int size) {
            this.width = width;
            this.height = height;
            this.tiles = new HashSet();
            while (size > 0) {
                int y;
                int x = new Random().nextInt(width);
                Vector tile = new Vector(x, y = new Random().nextInt(height));
                if (!this.tiles.add(tile)) continue;
                --size;
            }
            this.snake.addFirst(new Vector(0, 0));
            this.snake.addFirst(new Vector(1, 0));
            this.snake.addFirst(new Vector(2, 0));
            this.snake.addFirst(new Vector(3, 0));
            this.direction = Direction.RIGHT;
        }

        void update() throws Exception {
            Vector curr = this.snake.peekFirst();
            Vector next = null;
            switch (this.direction) {
                case RIGHT: {
                    next = new Vector(curr.x() + 1, curr.y());
                    break;
                }
                case LEFT: {
                    next = new Vector(curr.x() - 1, curr.y());
                    break;
                }
                case UP: {
                    next = new Vector(curr.x(), curr.y() - 1);
                    break;
                }
                case DOWN: {
                    next = new Vector(curr.x(), curr.y() + 1);
                }
            }
            if (next.x() < 0 || next.x() >= this.width || next.y() < 0 || next.y() >= this.height || this.snake.contains(next)) {
                throw new Exception("lost");
            }
            if (!this.tiles.remove(next)) {
                this.snake.removeLast();
            }
            this.snake.addFirst(next);
        }
    }

    static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

