/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.termd.core.io.BinaryDecoder;
import io.termd.core.io.BinaryEncoder;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.tty.TtyEventDecoder;
import io.termd.core.tty.TtyOutputMode;
import io.termd.core.util.Vector;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class HttpTtyConnection
implements TtyConnection {
    public static final Vector DEFAULT_SIZE = new Vector(80, 24);
    private Charset charset;
    private Vector size;
    private Consumer<Vector> sizeHandler;
    private final TtyEventDecoder eventDecoder;
    private final BinaryDecoder decoder;
    private final Consumer<int[]> stdout;
    private Consumer<Void> closeHandler;
    private Consumer<String> termHandler;
    private long lastAccessedTime = System.currentTimeMillis();

    public HttpTtyConnection() {
        this(StandardCharsets.UTF_8, DEFAULT_SIZE);
    }

    public HttpTtyConnection(Charset charset, Vector size) {
        this.charset = charset;
        this.size = size;
        this.eventDecoder = new TtyEventDecoder(3, 26, 4);
        this.decoder = new BinaryDecoder(512, charset, this.eventDecoder);
        this.stdout = new TtyOutputMode(new BinaryEncoder(charset, this::write));
    }

    @Override
    public Charset outputCharset() {
        return this.charset;
    }

    @Override
    public Charset inputCharset() {
        return this.charset;
    }

    @Override
    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public String terminalType() {
        return "vt100";
    }

    protected abstract void write(byte[] var1);

    public void writeToDecoder(byte[] bytes) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.decoder.write(bytes);
    }

    public void writeToDecoder(String msg) {
        String action;
        Map obj;
        ObjectMapper mapper = new ObjectMapper();
        try {
            obj = (Map)mapper.readValue(msg, Map.class);
            action = (String)obj.get("action");
        }
        catch (IOException e) {
            return;
        }
        if (action != null) {
            switch (action) {
                case "read": {
                    this.lastAccessedTime = System.currentTimeMillis();
                    String data = (String)obj.get("data");
                    this.decoder.write(data.getBytes());
                    break;
                }
                case "resize": {
                    try {
                        Vector newSize;
                        int cols = obj.getOrDefault("cols", this.size.x());
                        int rows = obj.getOrDefault("rows", this.size.y());
                        if (cols <= 0 || rows <= 0 || (newSize = new Vector(cols, rows)).equals(this.size())) break;
                        this.size = newSize;
                        if (this.sizeHandler == null) break;
                        this.sizeHandler.accept(this.size);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public Consumer<String> getTerminalTypeHandler() {
        return this.termHandler;
    }

    @Override
    public void setTerminalTypeHandler(Consumer<String> handler) {
        this.termHandler = handler;
    }

    @Override
    public Vector size() {
        return this.size;
    }

    @Override
    public Consumer<Vector> getSizeHandler() {
        return this.sizeHandler;
    }

    @Override
    public void setSizeHandler(Consumer<Vector> handler) {
        this.sizeHandler = handler;
    }

    @Override
    public BiConsumer<TtyEvent, Integer> getEventHandler() {
        return this.eventDecoder.getEventHandler();
    }

    @Override
    public void setEventHandler(BiConsumer<TtyEvent, Integer> handler) {
        this.eventDecoder.setEventHandler(handler);
    }

    @Override
    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getReadHandler();
    }

    @Override
    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setReadHandler(handler);
    }

    @Override
    public Consumer<int[]> stdoutHandler() {
        return this.stdout;
    }

    @Override
    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }
}

