/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2.providers;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.rxjava.ext.auth.oauth2.providers.OpenIDConnectAuth;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.oauth2.providers.GoogleAuth.class)
public class GoogleAuth
extends OpenIDConnectAuth {
    public static final TypeArg<GoogleAuth> __TYPE_ARG = new TypeArg(obj -> new GoogleAuth((io.vertx.ext.auth.oauth2.providers.GoogleAuth)obj), GoogleAuth::getDelegate);
    private final io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleAuth that = (GoogleAuth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public GoogleAuth(io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate) {
        super((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate);
        this.delegate = delegate;
    }

    public GoogleAuth(Object delegate) {
        super((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)((io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate;
    }

    public io.vertx.ext.auth.oauth2.providers.GoogleAuth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, String clientId, String clientSecret) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create((Vertx)vertx.getDelegate(), (String)clientId, (String)clientSecret));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create((Vertx)vertx.getDelegate(), (String)clientId, (String)clientSecret, (HttpClientOptions)httpClientOptions));
        return ret;
    }

    public static void discover(io.vertx.rxjava.core.Vertx vertx, OAuth2Options config, final Handler<AsyncResult<OAuth2Auth>> handler) {
        io.vertx.ext.auth.oauth2.providers.GoogleAuth.discover((Vertx)vertx.getDelegate(), (OAuth2Options)config, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static void discover(io.vertx.rxjava.core.Vertx vertx, OAuth2Options config) {
        GoogleAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)((Handler)ar -> {}));
    }

    public static Single<OAuth2Auth> rxDiscover(io.vertx.rxjava.core.Vertx vertx, OAuth2Options config) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> GoogleAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)fut)));
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, JsonObject serviceAccountJson) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create((Vertx)vertx.getDelegate(), (JsonObject)serviceAccountJson));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, JsonObject serviceAccountJson, HttpClientOptions httpClientOptions) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth.create((Vertx)vertx.getDelegate(), (JsonObject)serviceAccountJson, (HttpClientOptions)httpClientOptions));
        return ret;
    }

    public static GoogleAuth newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth arg) {
        return arg != null ? new GoogleAuth(arg) : null;
    }
}

