/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import java.util.concurrent.atomic.LongAdder;

class VertxNetServerMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> connections;
    private final Counters bytesReceived;
    private final Counters bytesSent;
    private final Counters errorCount;

    VertxNetServerMetrics(MeterRegistry registry, MetricsNaming names) {
        this(registry, MetricsDomain.NET_SERVER, names);
    }

    VertxNetServerMetrics(MeterRegistry registry, MetricsDomain domain, MetricsNaming names) {
        super(registry, domain);
        this.connections = this.longGauges(names.getNetActiveConnections(), "Number of opened connections to the server", Label.LOCAL, Label.REMOTE);
        this.bytesReceived = this.counters(names.getNetBytesRead(), "Number of bytes received by the server", Label.LOCAL, Label.REMOTE);
        this.bytesSent = this.counters(names.getNetBytesWritten(), "Number of bytes sent by the server", Label.LOCAL, Label.REMOTE);
        this.errorCount = this.counters(names.getNetErrorCount(), "Number of errors", Label.LOCAL, Label.REMOTE, Label.CLASS_NAME);
    }

    TCPMetrics forAddress(SocketAddress localAddress) {
        return new Instance(Labels.address(localAddress));
    }

    class Instance
    implements MicrometerMetrics,
    TCPMetrics<String> {
        final String local;

        Instance(String local) {
            this.local = local;
        }

        public String connected(SocketAddress remoteAddress, String remoteName) {
            String remote = Labels.address(remoteAddress, remoteName);
            ((LongAdder)VertxNetServerMetrics.this.connections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote, SocketAddress remoteAddress) {
            ((LongAdder)VertxNetServerMetrics.this.connections.get(this.local, remote)).decrement();
        }

        public void bytesRead(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetServerMetrics.this.bytesReceived.get(this.local, remote).increment((double)numberOfBytes);
        }

        public void bytesWritten(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetServerMetrics.this.bytesSent.get(this.local, remote).increment((double)numberOfBytes);
        }

        public void exceptionOccurred(String remote, SocketAddress remoteAddress, Throwable t) {
            VertxNetServerMetrics.this.errorCount.get(this.local, remote, t.getClass().getSimpleName()).increment();
        }

        public void close() {
        }

        @Override
        public MeterRegistry registry() {
            return VertxNetServerMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxNetServerMetrics.this.baseName();
        }
    }
}

