/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.compiler;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentWriter {
    private int indent = 0;
    private int parentIndents = 0;
    private boolean useIndent = false;
    private boolean empty = true;
    private Writer writer;
    private String pp = "  ";
    private boolean escape;
    private boolean compiledTag;
    private boolean compiledDoctype;

    public IndentWriter(Writer writer) {
        this.writer = writer;
    }

    public IndentWriter add(String string) {
        return this.append(string);
    }

    public IndentWriter append(String string) {
        this.write(string);
        return this;
    }

    public void increment() {
        ++this.indent;
    }

    public void decrement() {
        --this.indent;
    }

    private void write(String string) {
        try {
            this.writer.write(string);
            this.empty = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public void newline() {
        if (this.isPp()) {
            this.write("\n" + StringUtils.repeat("  ", this.indent));
        }
    }

    public void prettyIndent(int offset, boolean newline) {
        if (this.isPp()) {
            String newlineChar = newline ? "\n" : "";
            this.write(newlineChar + StringUtils.repeat(this.pp, this.indent + offset - 1));
        }
    }

    public void setUseIndent(boolean useIndent) {
        this.useIndent = useIndent;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public boolean isPp() {
        return this.pp.length() != 0 && this.useIndent;
    }

    public void setCompiledTag(boolean compiledTag) {
        this.compiledTag = compiledTag;
    }

    public boolean isCompiledTag() {
        return this.compiledTag;
    }

    public boolean isCompiledDoctype() {
        return this.compiledDoctype;
    }

    public void setCompiledDoctype(boolean compiledDoctype) {
        this.compiledDoctype = compiledDoctype;
    }
}

