/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.lexer;

import de.neuland.jade4j.lexer.token.AttributeList;
import java.util.Deque;
import java.util.LinkedList;

public class AttributeLexer {
    private String key = "";
    private String value = "";
    private AttributeList token;
    private Deque<State> states = new LinkedList<State>();
    private char quote = (char)32;

    public AttributeLexer() {
        this.states.add(State.KEY);
    }

    public AttributeList getToken(String input, int lineno) {
        this.token = new AttributeList(lineno);
        for (int i = 0; i < input.length(); ++i) {
            this.parse(input.charAt(i));
        }
        this.parse(',');
        return this.token;
    }

    private State state() {
        return this.states.getFirst();
    }

    private void parse(char c) {
        char real = c;
        block0 : switch (c) {
            case '\n': 
            case ',': {
                switch (this.state()) {
                    case EXPRESSION: 
                    case ARRAY: 
                    case STRING: 
                    case OBJECT: {
                        this.value = this.value + c;
                        break block0;
                    }
                }
                this.states.push(State.KEY);
                this.value = this.value.trim();
                this.key = this.key.trim();
                if ("".equals(this.key)) {
                    return;
                }
                String name = this.key.replaceAll("^['\"]|['\"]$", "");
                String cleanValue = this.value.replaceAll("^['\"]|['\"]$", "");
                if ("".equals(cleanValue) && this.quote == ' ') {
                    this.token.addBooleanAttribute(name, Boolean.TRUE);
                } else if (this.value.matches("^\"[^\"]*\"$") || this.value.matches("^'[^']*'$")) {
                    this.token.addAttribute(name, cleanValue, false);
                } else {
                    this.token.addExpressionAttribute(name, this.value, false);
                }
                this.key = "";
                this.value = "";
                this.quote = (char)32;
                break;
            }
            case '=': {
                this.parseAssign(real);
                break;
            }
            case '(': {
                this.parseExpressionStart(c);
                break;
            }
            case ')': {
                this.parseExpressionEnd(c);
                break;
            }
            case '{': {
                this.parseObjectStart(c);
                break;
            }
            case '}': {
                this.parseObjectEnd(c);
                break;
            }
            case '[': {
                this.parseArrayStart(c);
                break;
            }
            case ']': {
                this.parseArrayEnd(c);
                break;
            }
            case '\"': 
            case '\'': {
                this.parseQuotes(c);
                break;
            }
            default: {
                this.parseDefaults(c);
            }
        }
    }

    private void parseAssign(char real) {
        switch (this.state()) {
            case KEY_CHAR: {
                this.key = this.key + real;
                break;
            }
            case EXPRESSION: 
            case ARRAY: 
            case STRING: 
            case OBJECT: 
            case VALUE: {
                this.value = this.value + real;
                break;
            }
            default: {
                this.states.push(State.VALUE);
            }
        }
    }

    private void parseExpressionStart(char c) {
        if (this.state() == State.VALUE || this.state() == State.EXPRESSION) {
            this.states.push(State.EXPRESSION);
        }
        this.value = this.value + c;
    }

    private void parseExpressionEnd(char c) {
        if (this.state() == State.VALUE || this.state() == State.EXPRESSION) {
            this.states.pop();
        }
        this.value = this.value + c;
    }

    private void parseObjectStart(char c) {
        if (this.state() == State.VALUE) {
            this.states.push(State.OBJECT);
        }
        this.value = this.value + c;
    }

    private void parseObjectEnd(char c) {
        if (this.state() == State.OBJECT) {
            this.states.pop();
        }
        this.value = this.value + c;
    }

    private void parseArrayStart(char c) {
        if (this.state() == State.VALUE) {
            this.states.push(State.ARRAY);
        }
        this.value = this.value + c;
    }

    private void parseArrayEnd(char c) {
        if (this.state() == State.ARRAY) {
            this.states.pop();
        }
        this.value = this.value + c;
    }

    private void parseQuotes(char c) {
        switch (this.state()) {
            case KEY: {
                this.states.push(State.KEY_CHAR);
                break;
            }
            case KEY_CHAR: {
                this.states.pop();
                break;
            }
            case STRING: {
                if (c == this.quote) {
                    this.states.pop();
                }
                this.value = this.value + c;
                break;
            }
            default: {
                this.states.push(State.STRING);
                this.value = this.value + c;
                this.quote = c;
            }
        }
    }

    private void parseDefaults(char c) {
        switch (this.state()) {
            case KEY_CHAR: 
            case KEY: {
                this.key = this.key + c;
                break;
            }
            default: {
                this.value = this.value + c;
            }
        }
    }

    public static enum State {
        KEY,
        KEY_CHAR,
        VALUE,
        EXPRESSION,
        ARRAY,
        STRING,
        OBJECT;

    }
}

