/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import java.util.Collection;
import java.util.Iterator;

public class PrimitiveCollections {

    public static abstract class AbstractPrimitiveCollection<T>
    implements Collection<T> {
        private final int size;

        public AbstractPrimitiveCollection(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size <= 0;
        }

        public abstract T get(int var1);

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < AbstractPrimitiveCollection.this.size;
                }

                @Override
                public T next() {
                    Object t = AbstractPrimitiveCollection.this.get(this.index);
                    ++this.index;
                    return t;
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class DoubleCollection
    extends AbstractPrimitiveCollection<Double> {
        private final double[] array;

        public DoubleCollection(double[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Double get(int index) {
            return this.array[index];
        }
    }

    public static class FloatCollection
    extends AbstractPrimitiveCollection<Float> {
        private final float[] array;

        public FloatCollection(float[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this.array[index]);
        }
    }

    public static class LongCollection
    extends AbstractPrimitiveCollection<Long> {
        private final long[] array;

        public LongCollection(long[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Long get(int index) {
            return this.array[index];
        }
    }

    public static class IntegerCollection
    extends AbstractPrimitiveCollection<Integer> {
        private final int[] array;

        public IntegerCollection(int[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }
    }

    public static class ShortCollection
    extends AbstractPrimitiveCollection<Short> {
        private final short[] array;

        public ShortCollection(short[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Short get(int index) {
            return this.array[index];
        }
    }

    public static class CharacterCollection
    extends AbstractPrimitiveCollection<Character> {
        private final char[] array;

        public CharacterCollection(char[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.array[index]);
        }
    }

    public static class ByteCollection
    extends AbstractPrimitiveCollection<Byte> {
        private final byte[] array;

        public ByteCollection(byte[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Byte get(int index) {
            return this.array[index];
        }
    }

    public static class BooleanCollection
    extends AbstractPrimitiveCollection<Boolean> {
        private final boolean[] array;

        public BooleanCollection(boolean[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }
    }

    public static class ObjectCollection<T>
    extends AbstractPrimitiveCollection<Object> {
        private final T[] array;

        public ObjectCollection(T[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public T get(int index) {
            return this.array[index];
        }
    }
}

