/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.MetaDataService;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.WebAuthnImpl;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface WebAuthn
extends AuthenticationProvider {
    public static WebAuthn create(Vertx vertx) {
        return WebAuthn.create(vertx, new WebAuthnOptions());
    }

    public static WebAuthn create(Vertx vertx, WebAuthnOptions options) {
        return new WebAuthnImpl(vertx, options);
    }

    @Fluent
    public WebAuthn createCredentialsOptions(JsonObject var1, Handler<AsyncResult<JsonObject>> var2);

    default public Future<JsonObject> createCredentialsOptions(JsonObject user) {
        Promise promise = Promise.promise();
        this.createCredentialsOptions(user, (Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    @Fluent
    public WebAuthn getCredentialsOptions(@Nullable String var1, Handler<AsyncResult<JsonObject>> var2);

    default public Future<JsonObject> getCredentialsOptions(@Nullable String username) {
        Promise promise = Promise.promise();
        this.getCredentialsOptions(username, (Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    @Fluent
    public WebAuthn authenticatorFetcher(Function<Authenticator, Future<List<Authenticator>>> var1);

    @Fluent
    public WebAuthn authenticatorUpdater(Function<Authenticator, Future<Void>> var1);

    public MetaDataService metaDataService();
}

