/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.client.AsyncListCollectionsIterable;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ListCollectionsPublisherImpl<TResult>
implements ListCollectionsPublisher<TResult> {
    private final AsyncListCollectionsIterable<TResult> wrapped;

    ListCollectionsPublisherImpl(AsyncListCollectionsIterable<TResult> wrapped) {
        this.wrapped = (AsyncListCollectionsIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public ListCollectionsPublisher<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListCollectionsPublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<TResult> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    public void subscribe(Subscriber<? super TResult> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

