/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.RegistrationInfo;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class SubsOpSerializer {
    private final VertxInternal vertx;
    private final TaskQueue taskQueue;

    private SubsOpSerializer(VertxInternal vertx) {
        this.vertx = vertx;
        this.taskQueue = new TaskQueue();
    }

    public static SubsOpSerializer get(ContextInternal context) {
        ConcurrentMap contextData = context.contextData();
        SubsOpSerializer instance = (SubsOpSerializer)contextData.get(SubsOpSerializer.class);
        if (instance == null) {
            SubsOpSerializer candidate = new SubsOpSerializer(context.owner());
            SubsOpSerializer previous = contextData.putIfAbsent(SubsOpSerializer.class, candidate);
            instance = previous == null ? candidate : previous;
        }
        return instance;
    }

    public void execute(BiConsumer<String, RegistrationInfo> op, String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        this.taskQueue.execute(() -> {
            try {
                op.accept(address, registrationInfo);
                promise.complete();
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        }, (Executor)this.vertx.getWorkerPool());
    }
}

