/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Objects;

public class DB2DatabaseMetadata
implements DatabaseMetadata {
    private final boolean isZOS;
    private final String productName;
    private final String fullVersion;
    private final int majorVersion;
    private final int minorVersion;

    public DB2DatabaseMetadata(String serverReleaseLevel) {
        Objects.requireNonNull(serverReleaseLevel, "No server release level (SRVRLSLV) returned by server");
        this.fullVersion = serverReleaseLevel;
        if (serverReleaseLevel.startsWith("SQL")) {
            this.isZOS = false;
            this.productName = "DB2 for Linux/Unix/Windows";
        } else if (serverReleaseLevel.startsWith("DSN")) {
            this.isZOS = true;
            this.productName = "DB2 for z/OS";
        } else {
            throw new IllegalArgumentException("Received unknown server product release level: " + serverReleaseLevel);
        }
        if (serverReleaseLevel.length() < 7) {
            throw new IllegalArgumentException("Unable to determine server major/minor version from release level: " + serverReleaseLevel);
        }
        this.majorVersion = Integer.parseInt(serverReleaseLevel.substring(3, 5));
        this.minorVersion = Integer.parseInt(serverReleaseLevel.substring(5, 7));
    }

    public boolean isZOS() {
        return this.isZOS;
    }

    public String productName() {
        return this.productName;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }
}

